/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.Reference;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.dltk.internal.core.search.matching.OrPattern;

public class OrLocator
extends PatternLocator {
    protected PatternLocator[] patternLocators;

    public OrLocator(OrPattern pattern) {
        super(pattern);
        SearchPattern[] patterns = pattern.patterns;
        int length = patterns.length;
        this.patternLocators = new PatternLocator[length];
        int i = 0;
        while (i < length) {
            this.patternLocators[i] = PatternLocator.patternLocator(patterns[i]);
            ++i;
        }
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            this.patternLocators[i].initializePolymorphicSearch(locator);
            ++i;
        }
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        int level = 0;
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel > level) {
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
            ++i;
        }
        return level;
    }

    public int match(Expression node, MatchingNodeSet nodeSet) {
        int level = 0;
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel > level) {
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
            ++i;
        }
        return level;
    }

    public int match(FieldDeclaration node, MatchingNodeSet nodeSet) {
        int level = 0;
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel > level) {
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
            ++i;
        }
        return level;
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        int level = 0;
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel > level) {
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
            ++i;
        }
        return level;
    }

    public int match(Reference node, MatchingNodeSet nodeSet) {
        int level = 0;
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel > level) {
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
            ++i;
        }
        return level;
    }

    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        int level = 0;
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            int newLevel = this.patternLocators[i].match(node, nodeSet);
            if (newLevel > level) {
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
            ++i;
        }
        return level;
    }

    public int matchContainer() {
        int result = 0;
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            result |= this.patternLocators[i].matchContainer();
            ++i;
        }
        return result;
    }

    public SearchMatch newDeclarationMatch(ASTNode reference, IModelElement element, int accuracy, int length, MatchLocator locator) {
        PatternLocator closestPattern = null;
        int level = 3;
        int i = 0;
        int pl = this.patternLocators.length;
        while (i < pl) {
            PatternLocator patternLocator = this.patternLocators[i];
            int newLevel = patternLocator.resolveLevel(reference);
            if (newLevel > level) {
                closestPattern = patternLocator;
                if (newLevel == 3) break;
                level = newLevel;
            }
            ++i;
        }
        if (closestPattern != null) {
            return closestPattern.newDeclarationMatch(reference, element, accuracy, length, locator);
        }
        return locator.newDeclarationMatch(element, accuracy, reference.sourceStart(), length);
    }

    public int resolveLevel(ASTNode node) {
        int level = 0;
        int i = 0;
        int length = this.patternLocators.length;
        while (i < length) {
            int newLevel = this.patternLocators[i].resolveLevel(node);
            if (newLevel > level) {
                if (newLevel == 3) {
                    return 3;
                }
                level = newLevel;
            }
            ++i;
        }
        return level;
    }
}

