/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.dialogs.OpenTypeSelectionDialog2;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class OpenTypeAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public OpenTypeAction() {
        this.setText(DLTKUIMessages.OpenTypeAction_label);
        this.setDescription(DLTKUIMessages.OpenTypeAction_description);
        this.setToolTipText(DLTKUIMessages.OpenTypeAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_TOOL_OPENTYPE);
    }

    protected abstract IDLTKUILanguageToolkit getUILanguageToolkit();

    public void run() {
        Shell parent = DLTKUIPlugin.getActiveWorkbenchShell();
        OpenTypeSelectionDialog2 dialog = new OpenTypeSelectionDialog2(parent, true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 0, this.getUILanguageToolkit());
        dialog.setTitle(DLTKUIMessages.OpenTypeAction_dialogTitle);
        dialog.setMessage(DLTKUIMessages.OpenTypeAction_dialogMessage);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = null;
            int i = 0;
            while (i < types.length) {
                type = (IType)types[i];
                try {
                    DLTKUIPlugin.openInEditor((IModelElement)type, true, true);
                }
                catch (CoreException x) {
                    ExceptionHandler.handle(x, DLTKUIMessages.OpenTypeAction_errorTitle, DLTKUIMessages.OpenTypeAction_errorMessage);
                }
                ++i;
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

