/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.folding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProviderExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractASTFoldingStructureProvider
implements IFoldingStructureProvider,
IFoldingStructureProviderExtension {
    private ITextEditor fEditor;
    private ProjectionListener fProjectionListener;
    private IModelElement fInput;
    private IElementChangedListener fElementListener;
    private final Filter fMemberFilter = new MemberFilter();
    private final Filter fCommentFilter = new CommentFilter();
    private IPreferenceStore fStore;
    private int fBlockLinesMin;
    private boolean fCommentsFolding;
    protected boolean fFoldNewLines = true;
    static /* synthetic */ Class class$0;

    public void install(ITextEditor editor, ProjectionViewer viewer, IPreferenceStore store) {
        this.internalUninstall();
        this.fStore = store;
        if (editor instanceof ScriptEditor) {
            this.fEditor = editor;
            this.fProjectionListener = new ProjectionListener(viewer);
        }
    }

    public void uninstall() {
        this.internalUninstall();
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.fEditor instanceof ScriptEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    protected void handleProjectionDisabled() {
        if (this.fElementListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    public final void initialize() {
        this.update(this.createInitialContext());
    }

    protected FoldingStructureComputationContext createInitialContext() {
        this.initializePreferences(this.fStore);
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(true);
    }

    protected FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return new FoldingStructureComputationContext(doc, model, allowCollapse);
    }

    private IModelElement getInputElement() {
        if (this.fEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
    }

    private void update(FoldingStructureComputationContext ctx) {
        if (ctx == null) {
            return;
        }
        HashMap<ScriptProjectionAnnotation, Position> additions = new HashMap<ScriptProjectionAnnotation, Position>();
        ArrayList<ScriptProjectionAnnotation> deletions = new ArrayList<ScriptProjectionAnnotation>();
        ArrayList<ScriptProjectionAnnotation> updates = new ArrayList<ScriptProjectionAnnotation>();
        this.computeFoldingStructure(ctx);
        LinkedHashMap updated = ctx.fMap;
        Map previous = this.computeCurrentStructure(ctx);
        Iterator<Object> e = updated.keySet().iterator();
        while (e.hasNext()) {
            ScriptProjectionAnnotation newAnnotation = (ScriptProjectionAnnotation)((Object)e.next());
            SourceRangeStamp stamp = newAnnotation.getStamp();
            Position newPosition = (Position)updated.get((Object)newAnnotation);
            List annotations = (List)previous.get(stamp);
            if (annotations == null) {
                additions.put(newAnnotation, newPosition);
                continue;
            }
            Iterator x = annotations.iterator();
            boolean matched = false;
            while (x.hasNext()) {
                Tuple tuple = (Tuple)x.next();
                ScriptProjectionAnnotation existingAnnotation = tuple.annotation;
                Position existingPosition = tuple.position;
                if (newAnnotation.isComment() != existingAnnotation.isComment()) continue;
                if (existingPosition != null && (!newPosition.equals((Object)existingPosition) || ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed())) {
                    existingPosition.setOffset(newPosition.getOffset());
                    existingPosition.setLength(newPosition.getLength());
                    if (ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed()) {
                        if (newAnnotation.isCollapsed()) {
                            existingAnnotation.markCollapsed();
                        } else {
                            existingAnnotation.markExpanded();
                        }
                    }
                    updates.add(existingAnnotation);
                }
                matched = true;
                x.remove();
                break;
            }
            if (!matched) {
                additions.put(newAnnotation, newPosition);
            }
            if (!annotations.isEmpty()) continue;
            previous.remove(stamp);
        }
        e = previous.values().iterator();
        while (e.hasNext()) {
            List list = (List)e.next();
            int size = list.size();
            int i = 0;
            while (i < size) {
                deletions.add(((Tuple)list.get((int)i)).annotation);
                ++i;
            }
        }
        Annotation[] removals = new Annotation[deletions.size()];
        deletions.toArray(removals);
        Annotation[] changes = new Annotation[updates.size()];
        updates.toArray(changes);
        ctx.getModel().modifyAnnotations(removals, additions, changes);
    }

    private void computeFoldingStructure(FoldingStructureComputationContext ctx) {
        try {
            String contents = ((ISourceReference)this.fInput).getSource();
            this.computeFoldingStructure(contents, ctx);
        }
        catch (ModelException modelException) {}
    }

    protected void computeFoldingStructure(String contents, FoldingStructureComputationContext ctx) {
        int i;
        if (this.fCommentsFolding) {
            IRegion[] commentRegions = this.computeCommentsRanges(contents);
            i = 0;
            while (i < commentRegions.length) {
                Position position;
                IRegion normalized = this.alignRegion(commentRegions[i], ctx);
                if (normalized != null && (position = this.createCommentPosition(normalized)) != null) {
                    int hash = contents.substring(normalized.getOffset(), normalized.getOffset() + normalized.getLength()).hashCode();
                    IModelElement element = null;
                    ctx.addProjectionRange(new ScriptProjectionAnnotation(this.initiallyCollapseComments(ctx), true, new SourceRangeStamp(hash, normalized.getLength()), element), position);
                }
                ++i;
            }
        }
        CodeBlock[] blockRegions = this.getCodeBlocks(contents);
        i = 0;
        while (i < blockRegions.length) {
            block12: {
                CodeBlock codeBlock = blockRegions[i];
                if (this.mayCollapse(codeBlock.statement, ctx)) {
                    Position position;
                    boolean cfr_ignored_0 = codeBlock.statement instanceof TypeDeclaration;
                    boolean collapseCode = this.initiallyCollapse(codeBlock.statement, ctx);
                    IRegion reg = codeBlock.region;
                    boolean multiline = false;
                    try {
                        Document d = new Document(contents);
                        multiline = this.isMultilineRegion((IDocument)d, reg);
                    }
                    catch (BadLocationException badLocationException) {}
                    IRegion normalized = this.alignRegion(reg, ctx);
                    if (normalized != null && multiline && (position = this.createMemberPosition(normalized)) != null) {
                        try {
                            int len = normalized.getOffset() + normalized.getLength();
                            if (contents.length() == len + 1) {
                                --len;
                            }
                            if (contents.length() >= len) {
                                int hash = contents.substring(normalized.getOffset(), len).hashCode();
                                IModelElement element = null;
                                ctx.addProjectionRange(new ScriptProjectionAnnotation(collapseCode, false, new SourceRangeStamp(hash, normalized.getLength()), element), position);
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            if (!DLTKCore.DEBUG) break block12;
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected int getMinimalFoldableLinesCount() {
        return this.fBlockLinesMin;
    }

    protected void initializePreferences(IPreferenceStore store) {
        this.fBlockLinesMin = store.getInt("editor_folding_lines_limit");
        this.fCommentsFolding = store.getBoolean("editor_comments_folding_enabled");
    }

    protected boolean isEmptyRegion(IDocument d, ITypedRegion r) throws BadLocationException {
        String s = d.get(r.getOffset(), r.getLength());
        return s.trim().length() == 0;
    }

    protected boolean isMultilineRegion(IDocument d, IRegion region) throws BadLocationException {
        int line1 = d.getLineOfOffset(region.getOffset());
        int line2 = d.getLineOfOffset(region.getOffset() + region.getLength());
        if (this.getMinimalFoldableLinesCount() > 0) {
            return line2 - line1 + 1 >= this.getMinimalFoldableLinesCount();
        }
        return line1 != line2;
    }

    protected final Position createCommentPosition(IRegion aligned) {
        return new CommentPosition(aligned.getOffset(), aligned.getLength());
    }

    protected final Position createMemberPosition(IRegion aligned) {
        return new ScriptElementPosition(aligned.getOffset(), aligned.getLength());
    }

    protected final IRegion alignRegion(IRegion region, FoldingStructureComputationContext ctx) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = ctx.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(region.getOffset() + region.getLength());
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }

    private ProjectionAnnotationModel getModel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ProjectionAnnotationModel)this.fEditor.getAdapter((Class)clazz);
    }

    private IDocument getDocument() {
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fEditor.getEditorInput());
    }

    private Map computeCurrentStructure(FoldingStructureComputationContext ctx) {
        HashMap<SourceRangeStamp, ArrayList<Tuple>> map = new HashMap<SourceRangeStamp, ArrayList<Tuple>>();
        ProjectionAnnotationModel model = ctx.getModel();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof ScriptProjectionAnnotation)) continue;
            ScriptProjectionAnnotation ann = (ScriptProjectionAnnotation)((Object)annotation);
            Position position = model.getPosition((Annotation)ann);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(ann.getStamp());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(ann.getStamp(), list);
            }
            list.add(new Tuple(ann, position));
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tuple)o1).position.getOffset() - ((Tuple)o2).position.getOffset();
            }
        };
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            Collections.sort(list, comparator);
        }
        return map;
    }

    public final void collapseMembers() {
        this.modifyFiltered(this.fMemberFilter, false);
    }

    public final void collapseComments() {
        this.modifyFiltered(this.fCommentFilter, false);
    }

    private void modifyFiltered(Filter filter, boolean expand) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return;
        }
        ArrayList<ScriptProjectionAnnotation> modified = new ArrayList<ScriptProjectionAnnotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            ScriptProjectionAnnotation annot;
            Object annotation = iter.next();
            if (!(annotation instanceof ScriptProjectionAnnotation) || expand != (annot = (ScriptProjectionAnnotation)((Object)annotation)).isCollapsed() || !filter.match(annot)) continue;
            if (expand) {
                annot.markExpanded();
            } else {
                annot.markCollapsed();
            }
            modified.add(annot);
        }
        model.modifyAnnotations(null, null, modified.toArray(new Annotation[modified.size()]));
    }

    protected abstract String getPartition();

    protected abstract String getCommentPartition();

    protected abstract IPartitionTokenScanner getPartitionScanner();

    protected abstract ISourceParser getSourceParser();

    protected abstract String[] getPartitionTypes();

    protected abstract ILog getLog();

    protected FoldingASTVisitor getFoldingVisitor(int offset) {
        return new FoldingASTVisitor(offset);
    }

    protected CodeBlock[] getCodeBlocks(String code) {
        return this.getCodeBlocks(code, 0);
    }

    protected CodeBlock[] getCodeBlocks(String code, int offset) {
        FoldingASTVisitor visitor;
        block2: {
            ISourceParser parser = this.getSourceParser();
            ModuleDeclaration decl = parser.parse(null, code.toCharArray(), null);
            visitor = this.getFoldingVisitor(offset);
            try {
                decl.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return visitor.getResults();
    }

    protected abstract boolean mayCollapse(ASTNode var1, FoldingStructureComputationContext var2);

    protected abstract boolean initiallyCollapse(ASTNode var1, FoldingStructureComputationContext var2);

    protected abstract boolean initiallyCollapseComments(FoldingStructureComputationContext var1);

    private void installDocumentStuff(Document document) {
        IDocumentPartitioner partitioner = this.getDocumentPartitioner();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(this.getPartition(), partitioner);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner(this.getPartitionScanner(), this.getPartitionTypes());
    }

    private void removeDocumentStuff(Document document) {
        document.setDocumentPartitioner(this.getPartition(), null);
    }

    public void expandElements(final IModelElement[] array) {
        this.modifyFiltered(new Filter(){

            public boolean match(ScriptProjectionAnnotation annotation) {
                IModelElement element = annotation.getElement();
                if (element == null) {
                    return false;
                }
                int a = 0;
                while (a < array.length) {
                    IModelElement e = array[a];
                    if (e.equals(element)) {
                        return true;
                    }
                    ++a;
                }
                return false;
            }
        }, true);
    }

    public void collapseElements(IModelElement[] modelElements) {
    }

    private ITypedRegion getRegion(IDocument d, int offset) throws BadLocationException {
        return TextUtilities.getPartition((IDocument)d, (String)this.getPartition(), (int)offset, (boolean)true);
    }

    /*
     * Unable to fully structure code
     */
    protected IRegion[] computeCommentsRanges(String contents) {
        try {
            if (contents == null) {
                return new IRegion[0];
            }
            regions = new ArrayList<Region>();
            d = new Document(contents);
            this.installDocumentStuff(d);
            docRegionList = new ArrayList<ITypedRegion>();
            region = null;
            offset = 0;
            try {
                while (true) {
                    region = this.getRegion((IDocument)d, offset);
                    docRegionList.add(region);
                    offset = region.getLength() + region.getOffset() + 1;
                }
            }
            catch (BadLocationException v0) {
                docRegions = new ITypedRegion[docRegionList.size()];
                docRegionList.toArray(docRegions);
                fullRegion = null;
                start = -1;
                i = 0;
                ** while (i < docRegions.length)
            }
lbl-1000:
            // 1 sources

            {
                region = docRegions[i];
                multiline = this.isMultilineRegion((IDocument)d, (IRegion)region);
                badStart = false;
                if (d.getLineOffset(d.getLineOfOffset(region.getOffset())) != region.getOffset() && (lineStartStr = d.get(lineStart = d.getLineOffset(d.getLineOfOffset(region.getOffset())), region.getOffset() - lineStart)).trim().length() != 0) {
                    badStart = true;
                }
                if (!badStart && (region.getType().equals(this.getCommentPartition()) || start != -1 && this.isEmptyRegion((IDocument)d, region) && multiline && this.collapseEmptyLines() || start != -1 && this.isEmptyRegion((IDocument)d, region) && !multiline)) {
                    if (start == -1) {
                        start = i;
                    }
                } else {
                    if (start != -1) {
                        offset0 = docRegions[start].getOffset();
                        length0 = docRegions[i - 1].getOffset() - offset0 + docRegions[i - 1].getLength() - 1;
                        testForTrim = contents.substring(offset0, offset0 + length0).trim();
                        fullRegion = new Region(offset0, length0 = testForTrim.length());
                        if (this.isMultilineRegion((IDocument)d, (IRegion)fullRegion)) {
                            regions.add(fullRegion);
                        }
                    }
                    start = -1;
                }
                ++i;
                continue;
            }
lbl45:
            // 1 sources

            if (start != -1 && this.isMultilineRegion((IDocument)d, (IRegion)(fullRegion = new Region(offset0 = docRegions[start].getOffset(), length0 = docRegions[docRegions.length - 1].getOffset() - offset0 + docRegions[docRegions.length - 1].getLength() - 1)))) {
                regions.add(fullRegion);
            }
            this.removeDocumentStuff(d);
            result = new IRegion[regions.size()];
            regions.toArray(result);
            return result;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return new IRegion[0];
        }
    }

    protected boolean collapseEmptyLines() {
        return this.fFoldNewLines;
    }

    protected class CodeBlock {
        public ASTNode statement;
        public IRegion region;

        public CodeBlock(ASTNode s, IRegion r) {
            this.statement = s;
            this.region = r;
        }
    }

    private static final class CommentFilter
    implements Filter {
        private CommentFilter() {
        }

        public boolean match(ScriptProjectionAnnotation annotation) {
            return annotation.isComment() && !annotation.isMarkedDeleted();
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent(sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent(sequence, 0);
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IModelElementDelta delta = this.findElement(AbstractASTFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null && (delta.getFlags() & 9) != 0) {
                AbstractASTFoldingStructureProvider.this.update(AbstractASTFoldingStructureProvider.this.createContext(false));
            }
        }

        private IModelElementDelta findElement(IModelElement target, IModelElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (element.getElementType() > 5) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static interface Filter {
        public boolean match(ScriptProjectionAnnotation var1);
    }

    protected class FoldingASTVisitor
    extends ASTVisitor {
        private List result = new ArrayList();
        private int offset;

        protected FoldingASTVisitor(int offset) {
            this.offset = offset;
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            this.add((ASTNode)s);
            return super.visit(s);
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            this.add((ASTNode)s);
            return super.visit(s);
        }

        public CodeBlock[] getResults() {
            return this.result.toArray(new CodeBlock[this.result.size()]);
        }

        protected final void add(ASTNode s) {
            int start = this.offset + s.sourceStart();
            int end = s.sourceEnd() - s.sourceStart();
            this.result.add(new CodeBlock(s, (IRegion)new Region(start, end)));
        }
    }

    public final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        protected LinkedHashMap fMap = new LinkedHashMap();

        public FoldingStructureComputationContext(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing) {
            this.fDocument = document;
            this.fModel = model;
            this.fAllowCollapsing = allowCollapsing;
        }

        public Map getMap() {
            return this.fMap;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        IDocument getDocument() {
            return this.fDocument;
        }

        ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        public void addProjectionRange(ScriptProjectionAnnotation annotation, Position position) {
            this.fMap.put(annotation, position);
        }
    }

    private static final class MemberFilter
    implements Filter {
        private MemberFilter() {
        }

        public boolean match(ScriptProjectionAnnotation annotation) {
            return !annotation.isComment() && !annotation.isMarkedDeleted();
        }
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer viewer) {
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            AbstractASTFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            AbstractASTFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }

    private static final class ScriptElementPosition
    extends Position
    implements IProjectionPosition {
        public ScriptElementPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            return 0;
        }
    }

    protected static final class ScriptProjectionAnnotation
    extends ProjectionAnnotation {
        private boolean fIsComment;
        private SourceRangeStamp stamp;
        private IModelElement element;

        public ScriptProjectionAnnotation(boolean isCollapsed, boolean isComment, SourceRangeStamp codeStamp, IModelElement element) {
            super(isCollapsed);
            this.fIsComment = isComment;
            this.stamp = codeStamp;
            this.element = element;
        }

        public IModelElement getElement() {
            return this.element;
        }

        boolean isComment() {
            return this.fIsComment;
        }

        SourceRangeStamp getStamp() {
            return this.stamp;
        }

        void setStamp(SourceRangeStamp stamp) {
            this.stamp = stamp;
        }

        void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }

        public String toString() {
            return "ScriptProjectionAnnotation:\n\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment() + "\n";
        }
    }

    protected static final class SourceRangeStamp {
        private int hash;
        private int length;

        public SourceRangeStamp(int hash, int lenght) {
        }

        public int getHash() {
            return this.hash;
        }

        public void setHash(int hash) {
            this.hash = hash;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceRangeStamp) {
                SourceRangeStamp s = (SourceRangeStamp)obj;
                return s.hash == this.hash && s.length == this.length;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class Tuple {
        ScriptProjectionAnnotation annotation;
        Position position;

        Tuple(ScriptProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }
}

