/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.expressions;

import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.utils.CorePrinter;

public class FloatNumericLiteral
extends Literal {
    private double doubleValue;

    public FloatNumericLiteral(int start, int end, double value) {
        super(start, end);
        this.doubleValue = value;
    }

    public FloatNumericLiteral(int start, int end, String value) {
        super(start, end);
        this.doubleValue = Double.parseDouble(value);
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public String getValue() {
        return String.valueOf(this.doubleValue);
    }

    public int getKind() {
        return 1055;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn(this.getValue());
    }
}

