/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;

public class ProposalInfo {
    private boolean fScriptdocResolved = false;
    private String fScriptdoc = null;
    protected IModelElement fElement;

    public ProposalInfo(IMember member) {
        this.fElement = member;
    }

    protected ProposalInfo() {
        this.fElement = null;
    }

    public IModelElement getModelElement() throws ModelException {
        return this.fElement;
    }

    public String getInfo(IProgressMonitor monitor) {
        if (!this.fScriptdocResolved) {
            this.fScriptdocResolved = true;
            this.fScriptdoc = this.computeInfo(monitor);
        }
        return this.fScriptdoc;
    }

    private String computeInfo(IProgressMonitor monitor) {
        try {
            IModelElement modelElement = this.getModelElement();
            if (modelElement instanceof IMember) {
                IMember member = (IMember)modelElement;
                return this.extractScriptdoc(member, monitor);
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        catch (IOException e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }

    private String extractScriptdoc(IMember member, IProgressMonitor monitor) throws ModelException, IOException {
        Reader reader;
        if (member != null && (reader = this.getHTMLContentReader(member, monitor)) != null) {
            return ProposalInfo.getString(reader);
        }
        return null;
    }

    private Reader getHTMLContentReader(IMember member, IProgressMonitor monitor) throws ModelException {
        String nature = null;
        try {
            nature = DLTKLanguageManager.getLanguageToolkit((IModelElement)member).getNatureId();
        }
        catch (CoreException coreException) {
            return null;
        }
        if (nature == null) {
            return null;
        }
        return ScriptDocumentationAccess.getHTMLContentReader(nature, member, true, false);
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }
}

