/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;

public class TclASTUtil {
    public static List getStatements(ASTNode node) {
        if (node instanceof ModuleDeclaration) {
            return ((ModuleDeclaration)node).getStatements();
        }
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).getStatements();
        }
        if (node instanceof MethodDeclaration) {
            return ((MethodDeclaration)node).getStatements();
        }
        return null;
    }

    public static void extendStatements(ASTNode node, String content) {
        List statements = TclASTUtil.getStatements(node);
        if (statements != null) {
            int len = statements.size();
            int i = 0;
            while (i < len) {
                ASTNode nde = (ASTNode)statements.get(i);
                TclASTUtil.extendStatement(nde, content);
                TclASTUtil.extendStatements(nde, content);
                ++i;
            }
        }
    }

    public static void extendStatement(ASTNode node, String content) {
        int newValueStart = TclASTUtil.startLineOrSymbol(node, content);
        int newValueEnd = TclASTUtil.endLineOrSymbol(node, content);
        if (DLTKCore.DEBUG_COMPLETION && (node.sourceEnd() != newValueEnd || node.sourceStart() != newValueStart)) {
            System.out.println("Node Extended from:'" + content.substring(node.sourceStart(), node.sourceEnd()) + "'" + "to '" + content.substring(newValueStart, newValueEnd) + "'");
        }
        node.setStart(newValueStart);
        node.setEnd(newValueEnd);
    }

    public static int endLineOrSymbol(ASTNode node, String content) {
        return TclParseUtils.endLineOrSymbol(node.sourceEnd(), content);
    }

    public static int startLineOrSymbol(ASTNode node, String content) {
        return TclParseUtils.startLineOrSymbol(node.sourceStart(), content);
    }
}

