/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist.completion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.codeassist.complete.CompletionNodeFound;
import org.eclipse.dltk.compiler.env.lookup.Scope;
import org.eclipse.dltk.tcl.TclKeywordsManager;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclASTUtil;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclAssistParser;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnVariable;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;

public class TclCompletionParser
extends TclAssistParser {
    public void handleNotInElement(ASTNode node, int position) {
        if (node != null && node.sourceStart() <= position && position <= node.sourceEnd()) {
            if (node instanceof ModuleDeclaration) {
                ModuleDeclaration unit = (ModuleDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                TclEmptyCompleteStatement statement = new TclEmptyCompleteStatement(exprs);
                unit.addStatement((Statement)statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)unit, position);
            } else if (node instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                TclEmptyCompleteStatement statement = new TclEmptyCompleteStatement(exprs);
                method.getStatements().add(statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)method, position);
            } else if (node instanceof TypeDeclaration) {
                TypeDeclaration type = (TypeDeclaration)node;
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                TclEmptyCompleteStatement statement = new TclEmptyCompleteStatement(exprs);
                type.getStatements().add(statement);
                this.parseBlockStatements((ASTNode)statement, (ASTNode)type, position);
            } else if (node instanceof TclExecuteExpression) {
                ArrayList<SimpleReference> exprs = new ArrayList<SimpleReference>();
                exprs.add(new SimpleReference(position, position, ""));
                TclEmptyCompleteStatement statement = new TclEmptyCompleteStatement(exprs);
                this.parseBlockStatements((ASTNode)statement, node, position);
            }
        }
    }

    public void parseBlockStatements(ASTNode node, ASTNode inNode, int position) {
        if (node instanceof TclStatement) {
            SimpleReference nde;
            TclStatement statement = (TclStatement)node;
            List expressions = statement.getExpressions();
            int len = expressions.size();
            boolean first = false;
            ASTNode completionNode = null;
            String completionToken = null;
            int i = 0;
            while (i < len) {
                ASTNode n = (ASTNode)expressions.get(i);
                if (n.sourceStart() <= position && n.sourceEnd() >= position || node instanceof TclEmptyCompleteStatement) {
                    if (i == 0) {
                        first = true;
                    }
                    completionNode = n;
                }
                ++i;
            }
            if (completionNode == null) {
                if (len > 0) {
                    ASTNode firstNode = (ASTNode)expressions.get(0);
                    if (position > firstNode.sourceEnd()) {
                        boolean provideDollar = !this.checkVariableWithoutDollarCompletion(statement, position);
                        this.assistNodeParent = inNode;
                        SimpleReference ref = new SimpleReference(position, position, "");
                        CompletionOnVariable nde2 = new CompletionOnVariable("", (ASTNode)ref, node, inNode, true, provideDollar);
                        throw new CompletionNodeFound((ASTNode)nde2, null);
                    }
                } else {
                    completionToken = "";
                }
            } else if (completionNode instanceof SimpleReference) {
                completionToken = ((SimpleReference)completionNode).getName();
            } else if (completionNode instanceof TclBlockExpression) {
                TclBlockExpression block = (TclBlockExpression)completionNode;
                List s = block.parseBlock();
                if (s != null) {
                    int slen = s.size();
                    int u = 0;
                    while (u < slen) {
                        ASTNode n = (ASTNode)s.get(u);
                        n.setStart(n.sourceStart() - block.sourceStart());
                        n.setEnd(n.sourceEnd() - block.sourceStart());
                        TclASTUtil.extendStatement(n, block.getBlock());
                        n.setStart(n.sourceStart() + block.sourceStart());
                        n.setEnd(n.sourceEnd() + block.sourceStart());
                        if (n != null && n.sourceStart() <= position && n.sourceEnd() >= position) {
                            this.parseBlockStatements(n, inNode, position);
                        }
                        ++u;
                    }
                }
                this.handleNotInElement(inNode, position);
            }
            if (completionNode instanceof StringLiteral) {
                int pos = position - completionNode.sourceStart();
                SimpleReference tok = TclParseUtils.extractVariableFromString((StringLiteral)completionNode, pos);
                if (tok != null) {
                    this.assistNodeParent = inNode;
                    CompletionOnVariable nde3 = new CompletionOnVariable(tok.getName(), (ASTNode)tok, node, inNode, false);
                    throw new CompletionNodeFound((ASTNode)nde3, null);
                }
                this.assistNodeParent = inNode;
                SimpleReference ref = new SimpleReference(position, position, "");
                CompletionOnVariable nde4 = new CompletionOnVariable("", (ASTNode)ref, node, inNode, true);
                throw new CompletionNodeFound((ASTNode)nde4, null);
            }
            if (completionNode instanceof TclExecuteExpression) {
                TclExecuteExpression expr = (TclExecuteExpression)completionNode;
                List exprs = expr.parseExpression();
                int i2 = 0;
                while (i2 < exprs.size()) {
                    ASTNode n = (ASTNode)exprs.get(i2);
                    if (n.sourceStart() <= position && n.sourceEnd() >= position) {
                        this.parseBlockStatements(n, (ASTNode)expr, position);
                    }
                    ++i2;
                }
                this.handleNotInElement((ASTNode)expr, position);
            }
            if (completionToken != null && completionToken.startsWith("$")) {
                this.assistNodeParent = inNode;
                CompletionOnVariable nde5 = new CompletionOnVariable(completionToken, completionNode, node, inNode, false);
                throw new CompletionNodeFound((ASTNode)nde5, null);
            }
            if (inNode instanceof ModuleDeclaration && completionNode != null && first) {
                String[] keywords = this.checkKeywords(completionToken, 0);
                nde = new CompletionOnKeywordOrFunction(completionToken, completionNode, node, keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, (Scope)((ModuleDeclaration)inNode).scope);
            }
            if (inNode instanceof MethodDeclaration && completionNode != null && first) {
                String[] keywords = this.checkKeywords(completionToken, 2);
                nde = new CompletionOnKeywordOrFunction(completionToken, completionNode, node, keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, (Scope)((MethodDeclaration)inNode).scope);
            }
            if (inNode instanceof TypeDeclaration && completionNode != null && first) {
                String[] keywords = this.checkKeywords(completionToken, 1);
                nde = new CompletionOnKeywordOrFunction(completionToken, completionNode, node, keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, null);
            }
            if (inNode instanceof TclExecuteExpression && completionNode != null && first) {
                String[] keywords = this.checkKeywords(completionToken, 3);
                nde = new CompletionOnKeywordOrFunction(completionToken, completionNode, node, keywords);
                this.assistNodeParent = inNode;
                throw new CompletionNodeFound((ASTNode)nde, null);
            }
            if (this.checkVariableWithoutDollarCompletion(statement, position) && completionToken != null) {
                this.assistNodeParent = inNode;
                SimpleReference ref = new SimpleReference(completionNode.sourceStart(), completionNode.sourceEnd(), completionToken);
                nde = new CompletionOnVariable(completionToken, (ASTNode)ref, node, inNode, true);
                throw new CompletionNodeFound((ASTNode)nde, null);
            }
        } else if (node instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)node;
            List statements = method.getStatements();
            boolean inStatement = false;
            if (statements != null) {
                int length = statements.size();
                int i = 0;
                while (i < length) {
                    ASTNode nde = (ASTNode)statements.get(i);
                    if (nde.sourceStart() <= position && nde.sourceEnd() >= position) {
                        inStatement = true;
                        this.parseBlockStatements(nde, (ASTNode)method, position);
                    }
                    ++i;
                }
            }
            if (!inStatement) {
                this.handleNotInElement((ASTNode)method, position);
            }
        }
    }

    private boolean checkVariableWithoutDollarCompletion(TclStatement statement, int position) {
        SimpleReference ref;
        String name;
        Expression e = statement.getAt(0);
        return e instanceof SimpleReference && (name = (ref = (SimpleReference)e).getName()).equals("set");
    }

    private String[] checkKeywords(String completionToken, int type) {
        String[] keywords = TclKeywordsManager.getKeywords(type);
        if (type == 0 || type == 2 || type == 1 || type == 3) {
            String[] kw = new String[keywords.length];
            int i = 0;
            while (i < keywords.length) {
                kw[i] = keywords[i];
                ++i;
            }
            return kw;
        }
        return null;
    }

    private static class TclEmptyCompleteStatement
    extends TclStatement {
        public TclEmptyCompleteStatement(List expressions) {
            super(expressions);
        }
    }
}

