/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.internal.ui.text.ScriptElementProvider;
import org.eclipse.dltk.ruby.internal.ui.text.RubyAutoEditStrategy;
import org.eclipse.dltk.ruby.internal.ui.text.RubyCodeScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyDocScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyOutlineInformationControl;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPartitions;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPreferenceInterpreter;
import org.eclipse.dltk.ruby.internal.ui.text.RubyStringScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyTextTools;
import org.eclipse.dltk.ruby.internal.ui.text.completion.RubyCompletionProcessor;
import org.eclipse.dltk.ruby.internal.ui.text.completion.RubyContentAssistPreference;
import org.eclipse.dltk.ruby.internal.ui.typehierarchy.RubyHierarchyInformationControl;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.SingleTokenScriptScanner;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RubySourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private RubyTextTools fTextTools;
    private RubyCodeScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fCommentScanner;
    private AbstractScriptScanner fDocScanner;

    public RubySourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return RubyPartitions.RUBY_PARTITION_TYPES;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        RubyPreferenceInterpreter prefs = new RubyPreferenceInterpreter(this.fPreferenceStore);
        return new String[]{"\t", AutoEditUtils.getNSpaces((int)prefs.getIndentSize())};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(sourceViewer);
        }
        return this.fPreferenceStore.getInt("formatter.tabulation.size");
    }

    protected void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new RubyCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new RubyStringScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = new SingleTokenScriptScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_single_line_comment");
        this.fDocScanner = new RubyDocScanner(this.getColorManager(), this.fPreferenceStore);
    }

    private boolean isNewSetup() {
        return this.fTextTools == null;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_string");
        dr = new DefaultDamagerRepairer(this.getDocScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_doc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_doc");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_comment");
        return reconciler;
    }

    private ITokenScanner getDocScanner() {
        return this.fDocScanner;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fDocScanner.affectsBehavior(event)) {
            this.fDocScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fDocScanner.affectsBehavior(event);
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new RubyHierarchyInformationControl(parent, shellStyle, treeStyle);
            }
        };
    }

    public IInformationPresenter getHierarchyPresenter(ScriptSourceViewer sourceViewer, boolean doCodeResolve) {
        if (this.getEditor() != null && this.getEditor().getEditorInput() != null && EditorUtility.getEditorInputModelElement((IEditorPart)this.getEditor(), (boolean)true) == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator((ISourceViewer)sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning((ISourceViewer)sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        ScriptElementProvider provider = new ScriptElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    protected boolean isNewLine(IDocument doc, String text) {
        String[] delims = doc.getLegalLineDelimiters();
        int i = 0;
        while (i < delims.length) {
            if (delims[i].equals(text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        return new IAutoEditStrategy[]{new RubyAutoEditStrategy(this.fPreferenceStore, partitioning)};
    }

    protected IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new RubyOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#", ""};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() != null) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            assistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
            RubyCompletionProcessor scriptProcessor = new RubyCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
            assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
            RubyContentAssistPreference.getDefault().configure(assistant, this.fPreferenceStore);
            assistant.setContextInformationPopupOrientation(20);
            assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            return assistant;
        }
        return null;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), "My Status");
            }
        };
    }

    protected void initializeQuickOutlineContexts(InformationPresenter presenter, IInformationProvider provider) {
        presenter.setInformationProvider(provider, "__ruby_comment");
        presenter.setInformationProvider(provider, "__ruby_doc");
        presenter.setInformationProvider(provider, "__ruby_string");
    }
}

