/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text.completion;

import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.text.completion.TclCompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProcessor;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;

public class TclScriptCompletionProcessor
extends ScriptCompletionProcessor {
    private IContextInformationValidator validator;

    public TclScriptCompletionProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(editor, assistant, partition);
    }

    protected IPreferenceStore getPreferenceStore() {
        return TclUI.getDefault().getPreferenceStore();
    }

    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        return new ScriptContentAssistInvocationContext(viewer, offset, this.fEditor, "org.eclipse.dltk.tcl.core.nature"){

            protected CompletionProposalLabelProvider createLabelProvider() {
                return new TclCompletionProposalLabelProvider();
            }
        };
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.validator == null) {
            this.validator = new Validator();
        }
        return this.validator;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        private int initialOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(offset - this.initialOffset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.initialOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

