/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class ScriptProjectHelper {
    private static final int MAX_RETRY = 5;
    public static final IPath JUNIT_SRC_381 = new Path("testresources/junit381-noUI-src.zip");
    public static final String JUNIT_SRC_ENCODING = "ISO-8859-1";
    public static final IPath MYLIB = new Path("testresources/mylib.zip");

    public static IProjectFragment addSourceContainer(IScriptProject jproject, String containerName, IPath[] inclusionFilters, IPath[] exclusionFilters) throws CoreException {
        IProject project = jproject.getProject();
        IProject container = null;
        if (containerName == null || containerName.length() == 0) {
            container = project;
        } else {
            IFolder folder = project.getFolder(containerName);
            if (!folder.exists()) {
                CoreUtility.createFolder((IFolder)folder, (boolean)false, (boolean)true, null);
            }
            container = folder;
        }
        IProjectFragment root = jproject.getProjectFragment((IResource)container);
        IBuildpathEntry bpe = DLTKCore.newSourceEntry((IPath)root.getPath(), (IPath[])inclusionFilters, (IPath[])exclusionFilters, (IBuildpathAttribute[])BuildpathEntry.NO_EXTRA_ATTRIBUTES);
        ScriptProjectHelper.addToBuildpath(jproject, bpe);
        return root;
    }

    public static void addToBuildpath(IScriptProject jproject, IBuildpathEntry cpe) throws ModelException {
        IBuildpathEntry[] oldEntries = jproject.getRawBuildpath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(cpe)) {
                return;
            }
            ++i;
        }
        int nEntries = oldEntries.length;
        IBuildpathEntry[] newEntries = new IBuildpathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = cpe;
        jproject.setRawBuildpath(newEntries, null);
    }

    public static IProjectFragment addSourceContainer(IScriptProject jproject, String containerName) throws CoreException {
        return ScriptProjectHelper.addSourceContainer(jproject, containerName, (IPath[])new Path[0]);
    }

    public static IProjectFragment addSourceContainer(IScriptProject jproject, String containerName, IPath[] exclusionFilters) throws CoreException {
        return ScriptProjectHelper.addSourceContainer(jproject, containerName, (IPath[])new Path[0], exclusionFilters);
    }

    public static IScriptProject createScriptProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        description.setNatureIds(new String[]{"org.eclipse.dltk.core.tests.testnature"});
        if (!project.exists()) {
            project.create(description, null);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        IScriptProject jproject = DLTKCore.create((IProject)project);
        jproject.setRawBuildpath(new IBuildpathEntry[0], null);
        return jproject;
    }

    public static boolean setAutoBuilding(boolean state) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean result = desc.isAutoBuilding();
        desc.setAutoBuilding(state);
        workspace.setDescription(desc);
        return result;
    }

    public static void delete(final IModelElement elem) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (elem instanceof IScriptProject) {
                    IScriptProject jproject = (IScriptProject)elem;
                    jproject.setRawBuildpath(new IBuildpathEntry[0], null);
                }
                int i = 0;
                while (i < 5) {
                    try {
                        elem.getResource().delete(true, null);
                        i = 5;
                    }
                    catch (CoreException e) {
                        if (i == 4) {
                            DLTKUIPlugin.log((Throwable)e);
                            throw e;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public static IProjectFragment addLibrary(IScriptProject jproject, IPath path) throws ModelException {
        IBuildpathEntry cpe = DLTKCore.newLibraryEntry((IPath)path);
        ScriptProjectHelper.addToBuildpath(jproject, cpe);
        return jproject.getProjectFragment(path.toString());
    }

    public static IProjectFragment addSourceContainerWithImport(IScriptProject jproject, String containerName, File zipFile, String containerEncoding) throws InvocationTargetException, CoreException, IOException {
        return ScriptProjectHelper.addSourceContainerWithImport(jproject, containerName, zipFile, containerEncoding, (IPath[])new Path[0]);
    }

    public static IProjectFragment addSourceContainerWithImport(IScriptProject jproject, String containerName, File zipFile, String containerEncoding, IPath[] exclusionFilters) throws InvocationTargetException, CoreException, IOException {
        IProjectFragment iProjectFragment;
        block2: {
            ZipFile file = new ZipFile(zipFile);
            try {
                IProjectFragment root = ScriptProjectHelper.addSourceContainer(jproject, containerName, exclusionFilters);
                ((IContainer)root.getCorrespondingResource()).setDefaultCharset(containerEncoding, null);
                ScriptProjectHelper.importFilesFromZip(file, root.getPath(), null);
                iProjectFragment = root;
                Object var7_8 = null;
                if (file == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_9 = null;
                    if (file == null) break block3;
                    file.close();
                }
                throw throwable;
            }
            file.close();
        }
        return iProjectFragment;
    }

    private static void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        try {
            ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, (IOverwriteQuery)new ImportOverwriteQuery());
            op.run(monitor);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Exception decompiling
     */
    public static IProjectFragment addLibraryWithImport(IScriptProject jproject, IPath archivePath) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 77->80)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            return "ALL";
        }
    }
}

