/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ast.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;

public class ASTUtil {
    public static List getStatements(ASTNode node) {
        if (node instanceof ModuleDeclaration) {
            return ((ModuleDeclaration)node).getStatements();
        }
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).getStatements();
        }
        if (node instanceof MethodDeclaration) {
            return ((MethodDeclaration)node).getStatements();
        }
        return null;
    }

    public static TypeDeclaration[] getTypes(List statements, List types) {
        ArrayList<ASTNode> finalTypes = new ArrayList<ASTNode>();
        finalTypes.addAll(types);
        if (statements != null) {
            Iterator it = statements.iterator();
            while (it.hasNext()) {
                ASTNode node = (ASTNode)it.next();
                if (!(node instanceof TypeDeclaration) || finalTypes.contains(node)) continue;
                finalTypes.add(node);
            }
        }
        return finalTypes.toArray(new TypeDeclaration[finalTypes.size()]);
    }

    public static MethodDeclaration[] getMethods(List statements, List functions) {
        ArrayList<ASTNode> finalMethods = new ArrayList<ASTNode>();
        finalMethods.addAll(functions);
        if (statements != null) {
            Iterator it = statements.iterator();
            while (it.hasNext()) {
                ASTNode node = (ASTNode)it.next();
                if (!(node instanceof MethodDeclaration) || finalMethods.contains(node)) continue;
                finalMethods.add(node);
            }
        }
        return finalMethods.toArray(new MethodDeclaration[finalMethods.size()]);
    }

    public static FieldDeclaration[] getVariables(List statements, List variables) {
        ArrayList<ASTNode> finalVariables = new ArrayList<ASTNode>();
        finalVariables.addAll(variables);
        if (statements != null) {
            Iterator it = statements.iterator();
            while (it.hasNext()) {
                ASTNode node = (ASTNode)it.next();
                if (!(node instanceof FieldDeclaration) || finalVariables.contains(node)) continue;
                finalVariables.add(node);
            }
        }
        return finalVariables.toArray(new FieldDeclaration[finalVariables.size()]);
    }
}

