/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.dltk.debug.ui.breakpoints.ScriptBreakpointPropertyPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ScriptWatchpointPropertyPage
extends ScriptBreakpointPropertyPage {
    private Button suspendOnAccessButton;
    private Button suspendOnModificationButton;

    protected void createTypeSpecificLabels(Composite parent) throws CoreException {
        this.setTitle(BreakpointMessages.WatchpointTitle);
        IScriptWatchpoint watchPoint = (IScriptWatchpoint)this.getBreakpoint();
        this.createLabel(parent, BreakpointMessages.WatchFieldLabel);
        this.createLabel(parent, watchPoint.getFieldName());
    }

    protected boolean hasExpressionEditor() {
        return false;
    }

    protected void createTypeSpecificButtons(Composite parent) {
        this.suspendOnAccessButton = this.createCheckButton(parent, BreakpointMessages.SuspendOnAccessLabel);
        this.suspendOnModificationButton = this.createCheckButton(parent, BreakpointMessages.SuspendOnModificationLabel);
    }

    protected void loadValues() throws CoreException {
        super.loadValues();
        IScriptWatchpoint watchpoint = (IScriptWatchpoint)this.getBreakpoint();
        this.suspendOnAccessButton.setSelection(watchpoint.isAccess());
        this.suspendOnModificationButton.setSelection(watchpoint.isModification());
    }

    protected void saveValues() throws CoreException {
        super.saveValues();
        IScriptWatchpoint watchpoint = (IScriptWatchpoint)this.getBreakpoint();
        watchpoint.setAccess(this.suspendOnAccessButton.getSelection());
        watchpoint.setModification(this.suspendOnModificationButton.getSelection());
    }
}

