/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.dltk.ui.templates.TemplateMessages;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public final class ScriptTemplateVariables {
    private ScriptTemplateVariables() {
    }

    public static class File
    extends TemplateVariableResolver {
        public static final String NAME = "file";

        public File() {
            super(NAME, TemplateMessages.Variable_File_Description);
        }

        protected String resolve(TemplateContext context) {
            ISourceModule module = ((ScriptTemplateContext)context).getSourceModule();
            return module == null ? null : module.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    public static class Language
    extends TemplateVariableResolver {
        public static final String NAME = "language";

        public Language() {
            super(NAME, TemplateMessages.Variable_Language_Description);
        }

        protected String resolve(TemplateContext context) {
            try {
                ISourceModule module = ((ScriptTemplateContext)context).getSourceModule();
                IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)module);
                return toolkit.getLanguageName();
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }
}

