/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.dltk.console.IScriptConsoleIO;
import org.eclipse.dltk.console.InterpreterResponse;
import org.eclipse.dltk.console.ScriptConsoleXmlHelper;
import org.eclipse.dltk.console.ShellResponse;

public class ScriptConsoleIO
implements IScriptConsoleIO {
    private static final String INTERPRETER = "interpreter";
    private static final String SHELL = "shell";
    private final InputStream input;
    private final OutputStream output;
    private final String id;

    protected static void logInterpreterResponse(String response) {
        System.out.println("interpreter: " + response);
    }

    protected static void logShellResponse(String response) {
        System.out.println("shell: " + response);
    }

    protected static String readFixed(int len, InputStream input) throws IOException {
        byte[] buffer = new byte[len];
        int from = 0;
        while (from < buffer.length) {
            int n = input.read(buffer, from, buffer.length - from);
            if (n == -1) {
                return null;
            }
            from += n;
        }
        return new String(buffer);
    }

    protected static int readLength(InputStream input) throws IOException {
        String strLen = ScriptConsoleIO.readFixed(10, input);
        if (strLen == null) {
            return -1;
        }
        return Integer.parseInt(strLen);
    }

    protected static String readResponse(InputStream input) throws IOException {
        int len = ScriptConsoleIO.readLength(input);
        if (len == -1) {
            return null;
        }
        String xml = ScriptConsoleIO.readFixed(len, input);
        if (xml == null) {
            return null;
        }
        return xml;
    }

    public ScriptConsoleIO(InputStream input, OutputStream output) throws IOException {
        if (input == null || output == null) {
            throw new IllegalArgumentException();
        }
        this.input = input;
        this.output = output;
        this.id = ScriptConsoleXmlHelper.parseInfoXml(ScriptConsoleIO.readResponse(input));
    }

    public String getId() {
        return this.id;
    }

    public ShellResponse execShell(String command, String[] args) throws IOException {
        this.output.write("shell\n".getBytes());
        this.output.write((String.valueOf(command) + "\n").getBytes());
        int i = 0;
        while (i < args.length) {
            this.output.write((String.valueOf(args[i]) + "\n").getBytes());
            ++i;
        }
        this.output.flush();
        String response = ScriptConsoleIO.readResponse(this.input);
        ScriptConsoleIO.logShellResponse(response);
        return ScriptConsoleXmlHelper.parseShellXml(response);
    }

    public InterpreterResponse execInterpreter(String command) throws IOException {
        this.output.write("interpreter\n".getBytes());
        this.output.write((String.valueOf(command) + "\n").getBytes());
        this.output.flush();
        String response = ScriptConsoleIO.readResponse(this.input);
        ScriptConsoleIO.logInterpreterResponse(response);
        return ScriptConsoleXmlHelper.parseInterpreterXml(response);
    }

    public void close() throws IOException {
        this.input.close();
        this.output.close();
    }
}

