/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InterpreterDefinitionsContainer {
    private Map fInterTypeToInterMap = new HashMap(10);
    private List fInterpreterList;
    private List fInvalidInterpreterList = new ArrayList(10);
    private Map fDefaultInterpreterInstallCompositeID;
    private Map fDefaultInterpreterInstallConnectorTypeID;

    public InterpreterDefinitionsContainer() {
        this.fInterpreterList = new ArrayList(10);
        this.fDefaultInterpreterInstallCompositeID = new HashMap();
        this.fDefaultInterpreterInstallConnectorTypeID = new HashMap();
    }

    public String[] getInterpreterNatures() {
        Set s = this.fDefaultInterpreterInstallCompositeID.keySet();
        return s.toArray(new String[s.size()]);
    }

    public void addInterpreter(IInterpreterInstall Interpreter) {
        if (!this.fInterpreterList.contains(Interpreter)) {
            IInterpreterInstallType InterpreterInstallType = Interpreter.getInterpreterInstallType();
            ArrayList<IInterpreterInstall> InterpreterList = (ArrayList<IInterpreterInstall>)this.fInterTypeToInterMap.get(InterpreterInstallType);
            if (InterpreterList == null) {
                InterpreterList = new ArrayList<IInterpreterInstall>(3);
                this.fInterTypeToInterMap.put(InterpreterInstallType, InterpreterList);
            }
            InterpreterList.add(Interpreter);
            File installLocation = Interpreter.getInstallLocation();
            if (installLocation == null || !InterpreterInstallType.validateInstallLocation(installLocation).isOK()) {
                this.fInvalidInterpreterList.add(Interpreter);
            }
            this.fInterpreterList.add(Interpreter);
        }
    }

    public void addInterpreterList(List InterpreterList) {
        Iterator iterator = InterpreterList.iterator();
        while (iterator.hasNext()) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)iterator.next();
            this.addInterpreter(Interpreter);
        }
    }

    public Map getInterpreterTypeToInterpreterMap() {
        return this.fInterTypeToInterMap;
    }

    public List getInterpreterList() {
        return this.fInterpreterList;
    }

    public List getInterpreterList(String nature) {
        ArrayList<IInterpreterInstall> res = new ArrayList<IInterpreterInstall>(this.fInterpreterList.size());
        Iterator iter = this.fInterpreterList.iterator();
        while (iter.hasNext()) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)iter.next();
            if (!Interpreter.getInterpreterInstallType().getNatureId().equals(nature)) continue;
            res.add(Interpreter);
        }
        return res;
    }

    public List getValidInterpreterList() {
        List Interpreters = this.getInterpreterList();
        ArrayList resultList = new ArrayList(Interpreters.size());
        resultList.addAll(Interpreters);
        resultList.removeAll(this.fInvalidInterpreterList);
        return resultList;
    }

    public List getValidInterpreterList(String nature) {
        List Interpreters = this.getInterpreterList(nature);
        ArrayList resultList = new ArrayList(Interpreters.size());
        resultList.addAll(Interpreters);
        resultList.removeAll(this.fInvalidInterpreterList);
        return resultList;
    }

    public String getDefaultInterpreterInstallCompositeID(String nature) {
        return (String)this.fDefaultInterpreterInstallCompositeID.get(nature);
    }

    public String[] getDefaultInterpreterInstallCompositeID() {
        Collection ids = this.fDefaultInterpreterInstallCompositeID.values();
        return ids.toArray(new String[ids.size()]);
    }

    public void setDefaultInterpreterInstallCompositeID(String nature, String id) {
        if (id != null) {
            this.fDefaultInterpreterInstallCompositeID.put(nature, id);
        } else {
            this.fDefaultInterpreterInstallCompositeID.remove(nature);
        }
    }

    public String getDefaultInterpreterInstallConnectorTypeID(String nature) {
        return (String)this.fDefaultInterpreterInstallConnectorTypeID.get(nature);
    }

    public void setDefaultInterpreterInstallConnectorTypeID(String nature, String id) {
        this.fDefaultInterpreterInstallConnectorTypeID.put(nature, id);
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Element defaulte;
        String nature;
        Document doc = DLTKLaunchingPlugin.getDocument();
        Element config = doc.createElement("interpreterSettings");
        doc.appendChild(config);
        Iterator iter = this.fDefaultInterpreterInstallCompositeID.keySet().iterator();
        while (iter.hasNext()) {
            nature = (String)iter.next();
            defaulte = doc.createElement("defaultInterpreter");
            config.appendChild(defaulte);
            defaulte.setAttribute("nature", nature);
            defaulte.setAttribute("id", (String)this.fDefaultInterpreterInstallCompositeID.get(nature));
        }
        iter = this.fDefaultInterpreterInstallConnectorTypeID.keySet().iterator();
        while (iter.hasNext()) {
            nature = (String)iter.next();
            defaulte = doc.createElement("defaultInterpreterConnector");
            config.appendChild(defaulte);
            defaulte.setAttribute("nature", nature);
            defaulte.setAttribute("id", (String)this.fDefaultInterpreterInstallConnectorTypeID.get(nature));
        }
        Set InterpreterInstallTypeSet = this.getInterpreterTypeToInterpreterMap().keySet();
        Iterator keyIterator = InterpreterInstallTypeSet.iterator();
        while (keyIterator.hasNext()) {
            IInterpreterInstallType InterpreterInstallType = (IInterpreterInstallType)keyIterator.next();
            Element InterpreterTypeElement = this.interpreterTypeAsElement(doc, InterpreterInstallType);
            config.appendChild(InterpreterTypeElement);
        }
        return DLTKLaunchingPlugin.serializeDocument(doc);
    }

    private Element interpreterTypeAsElement(Document doc, IInterpreterInstallType InterpreterType) {
        Element element = doc.createElement("interpreterType");
        element.setAttribute("id", InterpreterType.getId());
        List InterpreterList = (List)this.getInterpreterTypeToInterpreterMap().get(InterpreterType);
        Iterator InterpreterIterator = InterpreterList.iterator();
        while (InterpreterIterator.hasNext()) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)InterpreterIterator.next();
            Element InterpreterElement = this.interpreterAsElement(doc, Interpreter);
            element.appendChild(InterpreterElement);
        }
        return element;
    }

    private Element interpreterAsElement(Document doc, IInterpreterInstall Interpreter) {
        String[] InterpreterArgs;
        Element element = doc.createElement("interpreter");
        element.setAttribute("id", Interpreter.getId());
        element.setAttribute("name", Interpreter.getName());
        String installPath = "";
        File installLocation = Interpreter.getInstallLocation();
        if (installLocation != null) {
            installPath = installLocation.toString();
        }
        element.setAttribute("path", installPath);
        LibraryLocation[] libraryLocations = Interpreter.getLibraryLocations();
        if (libraryLocations != null) {
            Element libLocationElement = InterpreterDefinitionsContainer.libraryLocationsAsElement(doc, libraryLocations);
            element.appendChild(libLocationElement);
        }
        if ((InterpreterArgs = Interpreter.getInterpreterArguments()) != null && InterpreterArgs.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < InterpreterArgs.length) {
                buffer.append(String.valueOf(InterpreterArgs[i]) + " ");
                ++i;
            }
            element.setAttribute("iargs", buffer.toString());
        }
        return element;
    }

    private static Element libraryLocationsAsElement(Document doc, LibraryLocation[] locations) {
        Element root = doc.createElement("libraryLocations");
        int i = 0;
        while (i < locations.length) {
            Element element = doc.createElement("libraryLocation");
            element.setAttribute("libraryPath", locations[i].getLibraryPath().toString());
            root.appendChild(element);
            ++i;
        }
        return root;
    }

    public static InterpreterDefinitionsContainer parseXMLIntoContainer(InputStream inputStream) throws IOException {
        InterpreterDefinitionsContainer container = new InterpreterDefinitionsContainer();
        InterpreterDefinitionsContainer.parseXMLIntoContainer(inputStream, container);
        return container;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parseXMLIntoContainer(InputStream inputStream, InterpreterDefinitionsContainer container) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        Element config = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                config = parser.parse(new InputSource(stream)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(LaunchingMessages.ScriptRuntime_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ((InputStream)stream).close();
                throw new IOException(LaunchingMessages.ScriptRuntime_badFormat);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            ((InputStream)stream).close();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        ((InputStream)stream).close();
        if (!config.getNodeName().equalsIgnoreCase("interpreterSettings")) {
            throw new IOException(LaunchingMessages.ScriptRuntime_badFormat);
        }
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                String id;
                String nature;
                Element InterpreterTypeElement = (Element)node;
                if (InterpreterTypeElement.getNodeName().equalsIgnoreCase("interpreterType")) {
                    InterpreterDefinitionsContainer.populateInterpreterTypes(InterpreterTypeElement, container);
                }
                if (InterpreterTypeElement.getNodeName().equalsIgnoreCase("defaultInterpreter")) {
                    nature = InterpreterTypeElement.getAttribute("nature");
                    id = InterpreterTypeElement.getAttribute("id");
                    container.setDefaultInterpreterInstallCompositeID(nature, id);
                }
                if (InterpreterTypeElement.getNodeName().equalsIgnoreCase("defaultInterpreterConnector")) {
                    nature = InterpreterTypeElement.getAttribute("nature");
                    id = InterpreterTypeElement.getAttribute("id");
                    container.setDefaultInterpreterInstallConnectorTypeID(nature, id);
                }
            }
            ++i;
        }
        return;
    }

    private static void populateInterpreterTypes(Element InterpreterTypeElement, InterpreterDefinitionsContainer container) {
        String id = InterpreterTypeElement.getAttribute("id");
        IInterpreterInstallType InterpreterType = ScriptRuntime.getInterpreterInstallType(id);
        if (InterpreterType != null) {
            NodeList InterpreterNodeList = InterpreterTypeElement.getChildNodes();
            int i = 0;
            while (i < InterpreterNodeList.getLength()) {
                Element InterpreterElement;
                Node InterpreterNode = InterpreterNodeList.item(i);
                short type = InterpreterNode.getNodeType();
                if (type == 1 && (InterpreterElement = (Element)InterpreterNode).getNodeName().equalsIgnoreCase("interpreter")) {
                    InterpreterDefinitionsContainer.populateInterpreterForType(InterpreterType, InterpreterElement, container);
                }
                ++i;
            }
        } else {
            DLTKLaunchingPlugin.log("Interpreter type element with unknown id.");
        }
    }

    private static void populateInterpreterForType(IInterpreterInstallType installType, Element element, InterpreterDefinitionsContainer container) {
        String id = element.getAttribute("id");
        if (id != null) {
            String installPath = element.getAttribute("path");
            if (installPath == null) {
                return;
            }
            InterpreterStandin standin = new InterpreterStandin(installType, id);
            standin.setName(element.getAttribute("name"));
            File installLocation = new File(installPath);
            standin.setInstallLocation(installLocation);
            container.addInterpreter(standin);
            NodeList list = element.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1) {
                    Element subElement = (Element)node;
                    String subElementName = subElement.getNodeName();
                    if (subElementName.equals("libraryLocation")) {
                        LibraryLocation loc = InterpreterDefinitionsContainer.getLibraryLocation(subElement);
                        standin.setLibraryLocations(new LibraryLocation[]{loc});
                        break;
                    }
                    if (subElementName.equals("libraryLocations")) {
                        InterpreterDefinitionsContainer.setLibraryLocations(standin, subElement);
                        break;
                    }
                }
                ++i;
            }
            String args = element.getAttribute("iargs");
            if (args != null && args.length() > 0) {
                standin.setInterpreterArgs(args);
            }
        } else {
            DLTKLaunchingPlugin.log("id attribute missing from Interpreter element specification.");
        }
    }

    private static LibraryLocation getLibraryLocation(Element libLocationElement) {
        String interpreterEnvironmentArchive = libLocationElement.getAttribute("libraryPath");
        if (interpreterEnvironmentArchive != null) {
            return new LibraryLocation((IPath)new Path(interpreterEnvironmentArchive));
        }
        DLTKLaunchingPlugin.log("Library location element is specified incorrectly.");
        return null;
    }

    private static void setLibraryLocations(IInterpreterInstall Interpreter, Element libLocationsElement) {
        NodeList list = libLocationsElement.getChildNodes();
        int length = list.getLength();
        ArrayList<LibraryLocation> locations = new ArrayList<LibraryLocation>(length);
        int i = 0;
        while (i < length) {
            Element libraryLocationElement;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (libraryLocationElement = (Element)node).getNodeName().equals("libraryLocation")) {
                locations.add(InterpreterDefinitionsContainer.getLibraryLocation(libraryLocationElement));
            }
            ++i;
        }
        Interpreter.setLibraryLocations(locations.toArray(new LibraryLocation[locations.size()]));
    }

    public void removeInterpreter(IInterpreterInstall Interpreter) {
        this.fInterpreterList.remove(Interpreter);
        this.fInvalidInterpreterList.remove(Interpreter);
        List list = (List)this.fInterTypeToInterMap.get(Interpreter.getInterpreterInstallType());
        if (list != null) {
            list.remove(Interpreter);
        }
    }
}

