/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.internal.ui.actions.OpenProjectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.CloseUnrelatedProjectsAction;
import org.eclipse.ui.ide.IDEActionFactory;

public class ProjectActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private OpenProjectAction fOpenAction;
    private CloseResourceAction fCloseAction;
    private CloseResourceAction fCloseUnrelatedAction;
    static /* synthetic */ Class class$0;

    public ProjectActionGroup(IViewPart part) {
        this.fSite = part.getSite();
        Shell shell = this.fSite.getShell();
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fCloseAction = new CloseResourceAction(shell);
        this.fCloseAction.setActionDefinitionId("org.eclipse.ui.project.closeProject");
        this.fCloseUnrelatedAction = new CloseUnrelatedProjectsAction(shell);
        this.fCloseUnrelatedAction.setActionDefinitionId("org.eclipse.ui.project.closeUnrelatedProjects");
        this.fOpenAction = new OpenProjectAction(this.fSite);
        this.fOpenAction.setActionDefinitionId("org.eclipse.ui.project.openProject");
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)selection;
            this.fOpenAction.selectionChanged(s);
            this.fCloseAction.selectionChanged(s);
            this.fCloseUnrelatedAction.selectionChanged(s);
        }
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fCloseUnrelatedAction);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.fCloseUnrelatedAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.fCloseAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId(), (IAction)this.fCloseUnrelatedAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.fOpenAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.fOpenAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fOpenAction);
        }
        if (this.fCloseAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fCloseAction);
        }
        if (this.fCloseUnrelatedAction.isEnabled() && this.areOnlyProjectsSelected(this.fCloseUnrelatedAction.getStructuredSelection())) {
            menu.appendToGroup("group.build", (IAction)this.fCloseUnrelatedAction);
        }
    }

    private boolean areOnlyProjectsSelected(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof IAdaptable)) continue;
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iAdaptable.getAdapter((Class)clazz) != null) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCloseUnrelatedAction);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseUnrelatedAction);
        super.dispose();
    }
}

