/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.debug.ui.preferences.ExternalDebuggingEngineOptionsBlock;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateDebuggerPlugin;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.ui.environment.EnvironmentPathBlock;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlockPropertyAndPreferencePage;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TclActiveStateDebuggerPreferencePage
extends AbstractConfigurationBlockPropertyAndPreferencePage {
    static PreferenceKey ENGINE_PATH = new PreferenceKey("org.eclipse.dltk.tcl.activestatedebugger", "debugging_engine_path");
    static PreferenceKey PDX_PATH = new PreferenceKey("org.eclipse.dltk.tcl.activestatedebugger", "debugging_engine_pdx_path");
    static PreferenceKey ENABLE_LOGGING = new PreferenceKey("org.eclipse.dltk.tcl.activestatedebugger", "enable_logging");
    static PreferenceKey LOG_FILE_PATH = new PreferenceKey("org.eclipse.dltk.tcl.activestatedebugger", "log_file_path");
    static PreferenceKey LOG_FILE_NAME = new PreferenceKey("org.eclipse.dltk.tcl.activestatedebugger", "log_file_name");
    private static String PREFERENCE_PAGE_ID = "org.eclipse.dltk.tcl.preferences.debug.activestatedebugger";
    private static String PROPERTY_PAGE_ID = "org.eclipse.dltk.tcl.propertyPage.debug.engines.activestatedebugger";

    protected AbstractOptionsBlock createOptionsBlock(IStatusChangeListener newStatusChangedListener, IProject project, IWorkbenchPreferenceContainer container) {
        return new ExternalDebuggingEngineOptionsBlock(newStatusChangedListener, project, new PreferenceKey[]{ENGINE_PATH, PDX_PATH, ENABLE_LOGGING, LOG_FILE_PATH, LOG_FILE_NAME}, container){
            private EnvironmentPathBlock pdxPath;

            protected void createEngineBlock(Composite parent) {
                super.createEngineBlock(parent);
                this.createPDXGroup(parent);
            }

            protected void createOtherBlock(Composite parent) {
                this.addDownloadLink(parent, PreferenceMessages.DebuggingEngineDownloadPage, PreferenceMessages.DebuggingEngineDownloadPageLink);
            }

            private void createPDXGroup(Composite parent) {
                Group group = SWTFactory.createGroup((Composite)parent, (String)PreferenceMessages.DebuggingEnginePDXGroup, (int)3, (int)1, (int)1808);
                this.pdxPath = new EnvironmentPathBlock();
                this.pdxPath.createControl((Composite)group);
                Map paths = EnvironmentPathUtils.decodePaths((String)this.getString(PDX_PATH));
                this.pdxPath.setPaths(paths);
            }

            protected boolean processChanges(IWorkbenchPreferenceContainer container) {
                String pdxPathKeyValue = EnvironmentPathUtils.encodePaths((Map)this.pdxPath.getPaths());
                this.setString(PDX_PATH, pdxPathKeyValue);
                return super.processChanges(container);
            }

            protected PreferenceKey getDebuggingEnginePathKey() {
                return ENGINE_PATH;
            }

            protected PreferenceKey getEnableLoggingPreferenceKey() {
                return ENABLE_LOGGING;
            }

            protected PreferenceKey getLogFileNamePreferenceKey() {
                return LOG_FILE_NAME;
            }

            protected PreferenceKey getLogFilePathPreferenceKey() {
                return LOG_FILE_PATH;
            }
        };
    }

    protected String getHelpId() {
        return null;
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }

    protected String getProjectHelpId() {
        return null;
    }

    protected String getPropertyPageId() {
        return PROPERTY_PAGE_ID;
    }

    protected void setDescription() {
        this.setDescription(PreferenceMessages.DebuggingEngineDescription);
    }

    protected void setPreferenceStore() {
        this.setPreferenceStore(TclActiveStateDebuggerPlugin.getDefault().getPreferenceStore());
    }
}

