/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.launcher;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.testing.launcher.ITestKind;
import org.eclipse.dltk.internal.testing.launcher.TestKindRegistry;

public class DLTKTestingLaunchConfigurationConstants {
    public static final String MODE_RUN_QUIETLY_MODE = "runQuietly";
    public static final String ID_JUNIT_APPLICATION = "org.eclipse.jdt.junit.launchconfig";
    public static final String ATTR_NO_DISPLAY = "org.eclipse.dltk.testing.NO_DISPLAY";
    public static final String ATTR_PORT = "org.eclipse.dltk.testing.PORT";
    public static final String ATTR_TEST_METHOD_NAME = "org.eclipse.dltk.testing.TESTNAME";
    public static final String ATTR_KEEPRUNNING = "org.eclipse.dltk.testing.KEEPRUNNING_ATTR";
    public static final String ATTR_TEST_CONTAINER = "org.eclipse.dltk.testing.CONTAINER";
    public static final String ATTR_FAILURES_NAMES = "org.eclipse.dltk.testing.FAILURENAMES";
    public static final String ATTR_TEST_RUNNER_KIND = "org.eclipse.dltk.testing.TEST_KIND";

    public static ITestKind getTestRunnerKind(ILaunchConfiguration launchConfiguration) {
        try {
            String loaderId = launchConfiguration.getAttribute(ATTR_TEST_RUNNER_KIND, null);
            if (loaderId != null) {
                return TestKindRegistry.getDefault().getKind(loaderId);
            }
        }
        catch (CoreException coreException) {}
        return ITestKind.NULL;
    }

    public static IScriptProject getScriptProject(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("project", null);
            if (projectName != null && projectName.length() > 0) {
                return DLTKCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

