/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;

    private Checks() {
    }

    public static boolean isAvailable(IModelElement modelElement) throws ModelException {
        if (modelElement == null) {
            return false;
        }
        if (!modelElement.exists()) {
            return false;
        }
        if (modelElement.isReadOnly()) {
            return false;
        }
        if (!(modelElement instanceof IScriptProject) && !modelElement.isStructureKnown()) {
            return false;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add binary modules support.");
        }
        return true;
    }

    public static boolean isBuildpathDelete(IProjectFragment pkgRoot) {
        IResource res = pkgRoot.getResource();
        if (res == null) {
            return true;
        }
        IProject definingProject = res.getProject();
        if (res.getParent() != null && pkgRoot.isArchive() && !res.getParent().equals((Object)definingProject)) {
            return true;
        }
        IProject occurringProject = pkgRoot.getScriptProject().getProject();
        return !definingProject.equals((Object)occurringProject);
    }

    public static RefactoringStatus checkSourceModuleNewName(ISourceModule cu, String newName) {
        String newCUName = ScriptModelUtil.getRenamedCUName((ISourceModule)cu, (String)newName);
        if (Checks.resourceExists(RenameResourceChange.renamedResourcePath(ResourceUtil.getResource(cu).getFullPath(), newCUName))) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.Checks_cu_name_used, newName));
        }
        return new RefactoringStatus();
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static boolean isAlreadyNamed(IModelElement element, String name) {
        return name.equals(element.getElementName());
    }
}

