/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDetector;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.internal.core.packages.TclCheckBuilder;

public class TclBuildpathDetector
extends BuildpathDetector {
    private Set packagesInBuild = new HashSet();
    private Set packageNamesInProject = new HashSet();
    private boolean useAnalysis;

    public TclBuildpathDetector(IProject project, IDLTKLanguageToolkit toolkit) throws CoreException {
        super(project, toolkit);
    }

    protected void addInterpreterContainer(ArrayList cpEntries) {
        cpEntries.add(InterpreterContainerHelper.createPackagesContainer((Set)this.packagesInBuild, (IPath)new Path(ScriptRuntime.INTERPRETER_CONTAINER)));
    }

    protected void processSources(List correctFiles, SubProgressMonitor sub) {
        if (this.useAnalysis) {
            sub.beginTask("Analysing", correctFiles.size());
            int count = 0;
            Iterator iterator = correctFiles.iterator();
            while (iterator.hasNext()) {
                IFile object = (IFile)iterator.next();
                sub.subTask("Analysing (" + String.valueOf(correctFiles.size() - count) + "):" + object.getName());
                this.processModule(object);
                ++count;
            }
            sub.done();
        }
    }

    private void processModule(IFile file) {
        block3: {
            ISourceModule module = DLTKCore.createSourceModuleFrom((IFile)file);
            if (module.exists()) {
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module, null);
                try {
                    TclCheckBuilder.fillPackagesDeclarations((ModuleDeclaration)moduleDeclaration, null, (Set)this.packagesInBuild, (Set)this.packageNamesInProject);
                }
                catch (Exception e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public void setUseAnalysis(boolean useAnalysis) {
        this.useAnalysis = useAnalysis;
    }
}

