/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.mixin.Messages;
import org.eclipse.dltk.internal.core.mixin.MixinIndexer;
import org.eclipse.dltk.internal.core.mixin.MixinManager;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;

public class MixinBuilder
implements IScriptBuilder {
    private static MixinBuilder builder = new MixinBuilder();

    public IStatus buildResources(IScriptProject project, List resources, IProgressMonitor monitor, int status) {
        return null;
    }

    public IStatus buildModelElements(IScriptProject project, List elements, IProgressMonitor monitor, int status) {
        return this.buildModelElements(project, elements, monitor, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus buildModelElements(IScriptProject project, List elements, IProgressMonitor monitor, boolean saveIndex) {
        block64: {
            block58: {
                block59: {
                    block57: {
                        if (elements.size() == 0) {
                            return null;
                        }
                        manager = ModelManager.getModelManager().getIndexManager();
                        elementsSize = elements.size();
                        toolkit = null;
                        parser = null;
                        try {
                            toolkit = DLTKLanguageManager.getLanguageToolkit(project);
                            if (toolkit != null) {
                                parser = MixinManager.getMixinParser(toolkit.getNatureId());
                            }
                        }
                        catch (CoreException e1) {
                            if (!DLTKCore.DEBUG) break block57;
                            e1.printStackTrace();
                        }
                    }
                    if (parser == null) return null;
                    if (toolkit == null) {
                        return null;
                    }
                    indexes = new HashMap<IPath, Index>();
                    mixinIndex = null;
                    imon = null;
                    try {
                        fullPath = project.getProject().getFullPath();
                        fullContainerPath = fullPath.getDevice() == null ? fullPath.toString() : fullPath.toOSString();
                        mixinIndex = manager.getSpecialIndex("mixin", fullPath.toString(), fullContainerPath);
                        imon = mixinIndex.monitor;
                        imon.enterWrite();
                        name = MessageFormat.format(Messages.MixinBuilder_buildingRuntimeModelFor, new Object[]{project.getElementName()});
                        if (monitor != null) {
                            monitor.beginTask(name, elementsSize);
                        }
                        fileIndex = 0;
                        iterator = elements.iterator();
                        while (iterator.hasNext()) {
                            element = (ISourceModule)iterator.next();
                            currentIndex = mixinIndex;
                            if (monitor != null && monitor.isCanceled()) {
                                var25_26 = null;
                                saveIndexesSet = new HashSet<Index>();
                                if (mixinIndex == null) break block58;
                                if (!saveIndex) break block59;
                                saveIndexesSet.add(mixinIndex);
                                break block58;
                            }
                            taskTitle = MessageFormat.format(Messages.MixinBuilder_buildingRuntimeModelFor2, new Object[]{project.getElementName(), new Integer(elements.size() - fileIndex), element.getElementName()});
                            ++fileIndex;
                            if (monitor != null) {
                                monitor.subTask(taskTitle);
                            }
                            projectFragment = (IProjectFragment)element.getAncestor(3);
                            containerPath = project.getPath();
                            if (projectFragment instanceof ExternalProjectFragment || projectFragment instanceof BuiltinProjectFragment) {
                                path = projectFragment.getPath();
                                if (indexes.containsKey(path)) {
                                    currentIndex = (Index)indexes.get(path);
                                    containerPath = path;
                                } else {
                                    contPath = path.toString();
                                    index = manager.getSpecialIndex("mixin", path.toString(), contPath);
                                    if (index != null) {
                                        currentIndex = index;
                                        if (!indexes.values().contains(index)) {
                                            index.monitor.enterWrite();
                                            indexes.put(path, index);
                                        }
                                        containerPath = path;
                                    }
                                }
                            }
                            participant = SearchEngine.getDefaultSearchParticipant();
                            document = new DLTKSearchDocument(element.getPath().toString(), containerPath, null, participant, element instanceof ExternalSourceModule);
                            document.toolkit = toolkit;
                            containerRelativePath = null;
                            if (element instanceof ExternalSourceModule) {
                                containerRelativePath = element.getPath().removeFirstSegments(containerPath.segmentCount()).setDevice(null).toString();
                            } else if (element instanceof SourceModule) {
                                containerRelativePath = element.getPath().removeFirstSegments(1).toPortableString();
                            } else if (element instanceof BuiltinSourceModule) {
                                containerRelativePath = document.getPath();
                            }
                            document.setContainerRelativePath(containerRelativePath);
                            currentIndex.remove(containerRelativePath);
                            document.setIndex(currentIndex);
                            new MixinIndexer(document, element, currentIndex).indexDocument();
                            if (monitor == null) continue;
                            monitor.worked(1);
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var26_50) {
                        var25_27 = null;
                        saveIndexesSet = new HashSet<Index>();
                        if (mixinIndex != null) {
                            if (saveIndex) {
                                saveIndexesSet.add(mixinIndex);
                            } else {
                                imon.exitWrite();
                            }
                        }
                        iterator = indexes.values().iterator();
                        ** GOTO lbl139
                    }
                }
                imon.exitWrite();
            }
            iterator = indexes.values().iterator();
            while (true) {
                block66: {
                    if (iterator.hasNext()) break block66;
                    if (saveIndex && (ind = saveIndexesSet.iterator()).hasNext()) {
                        index = (Index)ind.next();
                        if (monitor != null) {
                            containerPath = Path.fromPortableString((String)index.containerPath).setDevice(null).toString();
                            if (containerPath.startsWith("#special#")) {
                                containerPath = containerPath.substring(containerPath.lastIndexOf("#"), containerPath.length());
                            }
                            monitor.subTask(MessageFormat.format(Messages.MixinBuilder_savingIndexFor, new Object[]{containerPath}));
                        }
                        ** try [egrp 2[TRYBLOCK] [5 : 889->913)] { 
lbl111:
                        // 1 sources

                        break;
                    }
                    ** GOTO lbl136
                }
                index = (Index)iterator.next();
                if (saveIndex) {
                    saveIndexesSet.add(index);
                    continue;
                }
                index.monitor.exitWrite();
            }
            {
                try {
                    index.save();
                }
                catch (IOException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                    ** GOTO lbl-1000
                }
            }
lbl128:
            // 1 sources

            catch (Throwable var33_44) {
                v0 = null;
lbl130:
                // 2 sources

                while (true) {
                    var32_47 = v0;
                    index.monitor.exitWrite();
                    return null;
                }
            }
lbl-1000:
            // 2 sources

            {
                block65: {
                    block62: {
                        block63: {
                            block60: {
                                block61: {
                                    v0 = null;
                                    ** continue;
lbl136:
                                    // 1 sources

                                    if (monitor == null) return null;
                                    monitor.done();
                                    return null;
lbl139:
                                    // 1 sources

                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            if (saveIndex && (ind = saveIndexesSet.iterator()).hasNext()) {
                                                index = (Index)ind.next();
                                                if (monitor != null) {
                                                    containerPath = Path.fromPortableString((String)index.containerPath).setDevice(null).toString();
                                                    if (containerPath.startsWith("#special#")) {
                                                        containerPath = containerPath.substring(containerPath.lastIndexOf("#"), containerPath.length());
                                                    }
                                                    monitor.subTask(MessageFormat.format(Messages.MixinBuilder_savingIndexFor, new Object[]{containerPath}));
                                                }
                                                ** try [egrp 2[TRYBLOCK] [5 : 889->913)] { 
lbl149:
                                                // 1 sources

                                                break;
                                            }
                                            break block60;
                                        }
                                        index = (Index)iterator.next();
                                        if (saveIndex) {
                                            saveIndexesSet.add(index);
                                            continue;
                                        }
                                        index.monitor.exitWrite();
                                    }
                                    try {}
                                    catch (IOException e) {
                                        if (DLTKCore.DEBUG) {
                                            e.printStackTrace();
                                        }
                                        break block61;
                                    }
                                    index.save();
lbl165:
                                    // 1 sources

                                    catch (Throwable var33_45) {
                                        v1 = null;
lbl167:
                                        // 2 sources

                                        while (true) {
                                            var32_48 = v1;
                                            index.monitor.exitWrite();
                                            throw var26_50;
                                        }
                                    }
                                }
                                v1 = null;
                                ** continue;
                            }
                            if (monitor == null) throw var26_50;
                            monitor.done();
                            throw var26_50;
lbl-1000:
                            // 1 sources

                            {
                                var25_28 = null;
                                saveIndexesSet = new HashSet<Index>();
                                if (mixinIndex == null) break block62;
                                if (!saveIndex) break block63;
                                saveIndexesSet.add(mixinIndex);
                            }
                            break block62;
                        }
                        imon.exitWrite();
                    }
                    iterator = indexes.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (saveIndex && (ind = saveIndexesSet.iterator()).hasNext()) {
                                index = (Index)ind.next();
                                if (monitor != null) {
                                    containerPath = Path.fromPortableString((String)index.containerPath).setDevice(null).toString();
                                    if (containerPath.startsWith("#special#")) {
                                        containerPath = containerPath.substring(containerPath.lastIndexOf("#"), containerPath.length());
                                    }
                                    monitor.subTask(MessageFormat.format(Messages.MixinBuilder_savingIndexFor, new Object[]{containerPath}));
                                }
                                ** try [egrp 2[TRYBLOCK] [5 : 889->913)] { 
lbl199:
                                // 1 sources

                                break;
                            }
                            break block64;
                        }
                        index = (Index)iterator.next();
                        if (saveIndex) {
                            saveIndexesSet.add(index);
                            continue;
                        }
                        index.monitor.exitWrite();
                    }
                    try {}
                    catch (IOException e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        break block65;
                    }
                    index.save();
lbl215:
                    // 1 sources

                    catch (Throwable var33_46) {
                        v2 = null;
lbl217:
                        // 2 sources

                        while (true) {
                            var32_49 = v2;
                            index.monitor.exitWrite();
                            return null;
                        }
                    }
                }
                v2 = null;
                ** continue;
            }
        }
        if (monitor == null) return null;
        monitor.done();
        return null;
    }

    public static MixinBuilder getDefault() {
        return builder;
    }

    public int estimateElementsToBuild(List elements) {
        return elements.size();
    }

    public Set getDependencies(IScriptProject project, Set resources, Set allResources, Set oldExternalFolders, Set externalFolders) {
        return null;
    }
}

