/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.dltk.internal.testing.Messages;
import org.eclipse.dltk.internal.testing.ui.DLTKTestingMessages;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CounterPanel
extends Composite {
    protected Text fNumberOfErrors;
    protected Text fNumberOfFailures;
    protected Text fNumberOfRuns;
    protected int fTotal;
    protected int fIgnoredCount;
    private final Image fErrorIcon = TestRunnerViewPart.createImage("ovr16/error_ovr.gif");
    private final Image fFailureIcon = TestRunnerViewPart.createImage("ovr16/failed_ovr.gif");

    public CounterPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fNumberOfRuns = this.createLabel(DLTKTestingMessages.CounterPanel_label_runs, null, " 0/0  ");
        this.fNumberOfErrors = this.createLabel(DLTKTestingMessages.CounterPanel_label_errors, this.fErrorIcon, " 0 ");
        this.fNumberOfFailures = this.createLabel(DLTKTestingMessages.CounterPanel_label_failures, this.fFailureIcon, " 0 ");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CounterPanel.this.disposeIcons();
            }
        });
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
    }

    private Text createLabel(String name, Image image, String init) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Text value = new Text((Composite)this, 8);
        value.setText(init);
        value.setBackground(this.getDisplay().getSystemColor(22));
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void reset() {
        this.setErrorValue(0);
        this.setFailureValue(0);
        this.setRunValue(0, 0);
        this.fTotal = 0;
    }

    public void setTotal(int value) {
        this.fTotal = value;
    }

    public int getTotal() {
        return this.fTotal;
    }

    public void setRunValue(int value, int ignoredCount) {
        String runString = ignoredCount == 0 ? Messages.format(DLTKTestingMessages.CounterPanel_runcount, new String[]{Integer.toString(value), Integer.toString(this.fTotal)}) : Messages.format(DLTKTestingMessages.CounterPanel_runcount_ignored, new String[]{Integer.toString(value), Integer.toString(this.fTotal), Integer.toString(ignoredCount)});
        this.fNumberOfRuns.setText(runString);
        if (this.fIgnoredCount == 0 && ignoredCount > 0 || this.fIgnoredCount != 0 && ignoredCount == 0) {
            this.layout();
        } else {
            this.fNumberOfRuns.redraw();
            this.redraw();
        }
        this.fIgnoredCount = ignoredCount;
    }

    public void setErrorValue(int value) {
        this.fNumberOfErrors.setText(Integer.toString(value));
        this.redraw();
    }

    public void setFailureValue(int value) {
        this.fNumberOfFailures.setText(Integer.toString(value));
        this.redraw();
    }
}

