/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.viewsupport;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.viewsupport.HistoryDropDownAction;
import org.eclipse.dltk.ui.viewsupport.HistoryListAction;
import org.eclipse.dltk.ui.viewsupport.ViewHistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

class HistoryDropDownAction
extends Action {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private ViewHistory fHistory;
    private Menu fMenu;

    public HistoryDropDownAction(ViewHistory history) {
        this.fHistory = history;
        this.fMenu = null;
        this.setMenuCreator(new HistoryMenuCreator());
        this.fHistory.configureHistoryDropDownAction((IAction)this);
    }

    public void run() {
        new HistoryListAction(this.fHistory).run();
    }

    private class HistoryAction
    extends Action {
        private final Object fElement;

        public HistoryAction(Object element, int accelerator) {
            super("", 8);
            Assert.isNotNull((Object)element);
            this.fElement = element;
            String label = HistoryDropDownAction.this.fHistory.getText(element);
            if (accelerator < 10) {
                label = "" + '&' + accelerator + ' ' + label;
            }
            this.setText(label);
            this.setImageDescriptor(HistoryDropDownAction.this.fHistory.getImageDescriptor(element));
        }

        public void run() {
            HistoryDropDownAction.this.fHistory.setActiveEntry(this.fElement);
        }
    }

    private class HistoryMenuCreator
    implements IMenuCreator {
        private HistoryMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            if (HistoryDropDownAction.this.fMenu != null) {
                HistoryDropDownAction.this.fMenu.dispose();
            }
            MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(this, manager){
                final /* synthetic */ HistoryMenuCreator this$1;
                private final /* synthetic */ MenuManager val$manager;
                {
                    this.this$1 = historyMenuCreator;
                    this.val$manager = menuManager;
                }

                public void menuAboutToShow(IMenuManager manager2) {
                    List entries = HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)).getHistoryEntries();
                    boolean checkOthers = this.addEntryMenuItems(manager2, entries);
                    manager2.add((IContributionItem)new Separator());
                    HistoryListAction others = new HistoryListAction(HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)));
                    others.setChecked(checkOthers);
                    manager2.add((IAction)others);
                    Action clearAction = HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)).getClearAction();
                    if (clearAction != null) {
                        manager2.add((IAction)clearAction);
                    }
                    manager2.add((IContributionItem)new Separator("additions"));
                    HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)).addMenuEntries(this.val$manager);
                }

                private boolean addEntryMenuItems(IMenuManager manager2, List entries) {
                    if (entries.isEmpty()) {
                        return false;
                    }
                    boolean checkOthers = true;
                    int min = Math.min(entries.size(), 10);
                    int i = 0;
                    while (i < min) {
                        E entry = entries.get(i);
                        HistoryAction action = HistoryMenuCreator.access$1(this.this$1).new HistoryAction(entry, i + 1);
                        boolean check = entry.equals(HistoryDropDownAction.access$0(HistoryMenuCreator.access$1(this.this$1)).getCurrentEntry());
                        action.setChecked(check);
                        if (check) {
                            checkOthers = false;
                        }
                        manager2.add((IAction)action);
                        ++i;
                    }
                    return checkOthers;
                }
            });
            HistoryDropDownAction.this.fMenu = manager.createContextMenu(parent);
            Display display = parent.getDisplay();
            HistoryDropDownAction.this.fMenu.addMenuListener((MenuListener)new MenuAdapter(this, display, manager){
                final /* synthetic */ HistoryMenuCreator this$1;
                private final /* synthetic */ Display val$display;
                private final /* synthetic */ MenuManager val$manager;
                {
                    this.this$1 = historyMenuCreator;
                    this.val$display = display;
                    this.val$manager = menuManager;
                }

                public void menuHidden(MenuEvent e) {
                    this.val$display.asyncExec(new Runnable(this, this.val$manager){
                        final /* synthetic */ 2 this$2;
                        private final /* synthetic */ MenuManager val$manager;
                        {
                            this.this$2 = var1_1;
                            this.val$manager = menuManager;
                        }

                        public void run() {
                            this.val$manager.removeAll();
                            if (HistoryDropDownAction.access$1(HistoryMenuCreator.access$1(2.access$0(this.this$2))) != null) {
                                HistoryDropDownAction.access$1(HistoryMenuCreator.access$1(2.access$0(this.this$2))).dispose();
                                HistoryDropDownAction.access$2(HistoryMenuCreator.access$1(2.access$0(this.this$2)), null);
                            }
                        }
                    });
                }

                static /* synthetic */ HistoryMenuCreator access$0(2 var0) {
                    return var0.this$1;
                }
            });
            return HistoryDropDownAction.this.fMenu;
        }

        public void dispose() {
            HistoryDropDownAction.this.fHistory = null;
            if (HistoryDropDownAction.this.fMenu != null) {
                HistoryDropDownAction.this.fMenu.dispose();
                HistoryDropDownAction.this.fMenu = null;
            }
        }

        static /* synthetic */ HistoryDropDownAction access$1(HistoryMenuCreator historyMenuCreator) {
            return historyMenuCreator.HistoryDropDownAction.this;
        }
    }
}

