/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.InterpreterContainerInitializer;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathEntry;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntryResolver2;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterRuntimeBuildpathEntryResolver
implements IRuntimeBuildpathEntryResolver2 {
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    public IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        String nature = configuration.getAttribute("nature", null);
        IScriptProject project = AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration);
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
        IInterpreterInstall interpreterEnvironment = null;
        interpreterEnvironment = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? InterpreterContainerInitializer.resolveInterpreter(nature, environment.getId(), entry.getPath()) : ScriptRuntime.computeInterpreterInstall(configuration);
        if (interpreterEnvironment == null) {
            return new IRuntimeBuildpathEntry[0];
        }
        return this.resolveLibraryLocations(interpreterEnvironment, entry.getBuildpathProperty());
    }

    private String getNatureFromProject(IScriptProject project) {
        return DLTKLanguageManager.getLanguageToolkit((IModelElement)project).getNatureId();
    }

    private String getEnvironmentFromProject(IScriptProject project) {
        return EnvironmentManager.getEnvironment((IModelElement)project).getId();
    }

    public IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, IScriptProject project) throws CoreException {
        IInterpreterInstall interpreterEnvironment = null;
        interpreterEnvironment = entry.getType() == 4 && entry.getPath().segmentCount() > 1 ? InterpreterContainerInitializer.resolveInterpreter(this.getNatureFromProject(project), this.getEnvironmentFromProject(project), entry.getPath()) : ScriptRuntime.getInterpreterInstall(project);
        if (interpreterEnvironment == null) {
            return new IRuntimeBuildpathEntry[0];
        }
        return this.resolveLibraryLocations(interpreterEnvironment, entry.getBuildpathProperty());
    }

    protected IRuntimeBuildpathEntry[] resolveLibraryLocations(IInterpreterInstall interpreter, int kind) {
        LibraryLocation[] libs = interpreter.getLibraryLocations();
        LibraryLocation[] defaultLibs = interpreter.getInterpreterInstallType().getDefaultLibraryLocations(interpreter.getInstallLocation(), interpreter.getEnvironmentVariables(), null);
        if (libs == null) {
            libs = defaultLibs;
        } else if (!InterpreterRuntimeBuildpathEntryResolver.isSamePaths(libs, defaultLibs)) {
            kind = 2;
        }
        ArrayList<IRuntimeBuildpathEntry> resolvedEntries = new ArrayList<IRuntimeBuildpathEntry>(libs.length);
        IEnvironment environment = interpreter.getEnvironment();
        int i = 0;
        while (i < libs.length) {
            IPath systemLibraryPath = libs[i].getLibraryPath();
            if (!InterpreterRuntimeBuildpathEntryResolver.contains(defaultLibs, systemLibraryPath)) {
                IFileHandle fileHandle;
                boolean exists = environment != null ? ((fileHandle = EnvironmentPathUtils.getFile((IEnvironment)environment, (IPath)systemLibraryPath)) != null ? fileHandle.exists() : true) : systemLibraryPath.toFile().exists();
                if (exists) {
                    resolvedEntries.add(this.resolveLibraryLocation(interpreter, libs[i], kind));
                }
            }
            ++i;
        }
        return resolvedEntries.toArray(new IRuntimeBuildpathEntry[resolvedEntries.size()]);
    }

    private static boolean contains(LibraryLocation[] libs, IPath path) {
        IPathCompare compare = InterpreterRuntimeBuildpathEntryResolver.getPlatformPathCompare();
        int i = 0;
        while (i < libs.length) {
            if (compare.equals(path, libs[i].getLibraryPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSamePaths(LibraryLocation[] libs, LibraryLocation[] defaultLibs) {
        int length = defaultLibs.length;
        if (libs.length != length) {
            return false;
        }
        if (length != 0) {
            IPathCompare compare = InterpreterRuntimeBuildpathEntryResolver.getPlatformPathCompare();
            int i = 0;
            while (i < length) {
                IPath lpath;
                IPath dpath = defaultLibs[i].getLibraryPath();
                if (!compare.equals(dpath, lpath = libs[i].getLibraryPath())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static IPathCompare getPlatformPathCompare() {
        IPathCompare compare = Platform.getOS().equals("win32") ? new Win32PathCompare() : new GenericPathCompare();
        return compare;
    }

    public static boolean isSameArchives(LibraryLocation[] libs, LibraryLocation[] defaultLibs) {
        if (libs.length != defaultLibs.length) {
            return false;
        }
        int i = 0;
        while (i < defaultLibs.length) {
            LibraryLocation def = defaultLibs[i];
            LibraryLocation lib = libs[i];
            if (!def.getLibraryPath().equals((Object)lib.getLibraryPath())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IInterpreterInstall resolveInterpreterInstall(String lang, String environment, IBuildpathEntry entry) {
        if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER)) {
            try {
                return InterpreterContainerInitializer.resolveInterpreter(lang, environment, entry.getPath());
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    public boolean isInterpreterInstallReference(String lang, String environment, IBuildpathEntry entry) {
        return entry.getEntryKind() == 5 && entry.getPath().segment(0).equals(ScriptRuntime.INTERPRETER_CONTAINER);
    }

    private IRuntimeBuildpathEntry resolveLibraryLocation(IInterpreterInstall Interpreter, LibraryLocation location, int kind) {
        IPath libraryPath = location.getLibraryPath();
        IBuildpathAttribute[] attributes = new IBuildpathAttribute[]{};
        IBuildpathEntry bpe = DLTKCore.newLibraryEntry((IPath)libraryPath, (IAccessRule[])EMPTY_RULES, (IBuildpathAttribute[])attributes, (boolean)false, (boolean)false);
        RuntimeBuildpathEntry resolved = new RuntimeBuildpathEntry(bpe);
        resolved.setBuildpathProperty(kind);
        return resolved;
    }

    private static final class GenericPathCompare
    implements IPathCompare {
        private GenericPathCompare() {
        }

        public boolean equals(IPath path1, IPath path2) {
            return path1.equals((Object)path2);
        }
    }

    private static interface IPathCompare {
        public boolean equals(IPath var1, IPath var2);
    }

    private static final class Win32PathCompare
    implements IPathCompare {
        private Win32PathCompare() {
        }

        public boolean equals(IPath path1, IPath path2) {
            return path1.removeTrailingSeparator().toOSString().equalsIgnoreCase(path2.removeTrailingSeparator().toOSString());
        }
    }
}

