/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.AccessRulesLabelProvider;
import org.eclipse.dltk.internal.ui.wizards.buildpath.ArchiveFileFilter;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElementAttribute;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPUserLibraryElement;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;

public class BPListLabelProvider
extends LabelProvider {
    private String fNewLabel = NewWizardMessages.CPListLabelProvider_new;
    private String fClassLabel = NewWizardMessages.CPListLabelProvider_classcontainer;
    private String fCreateLabel = NewWizardMessages.CPListLabelProvider_willbecreated;
    private ImageDescriptorRegistry fRegistry = DLTKUIPlugin.getImageDescriptorRegistry();
    private ImageDescriptor fProjectImage;

    public BPListLabelProvider() {
        IWorkbench workbench = DLTKUIPlugin.getDefault().getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public String getText(Object element) {
        if (element instanceof BPListElement) {
            return this.getCPListElementText((BPListElement)element);
        }
        if (element instanceof BPListElementAttribute) {
            BPListElementAttribute attribute = (BPListElementAttribute)element;
            String text = this.getCPListElementAttributeText(attribute);
            if (attribute.isInNonModifiableContainer()) {
                return Messages.format(NewWizardMessages.CPListLabelProvider_non_modifiable_attribute, text);
            }
            return text;
        }
        if (element instanceof BPUserLibraryElement) {
            return this.getCPUserLibraryText((BPUserLibraryElement)element);
        }
        if (element instanceof IAccessRule) {
            IAccessRule rule = (IAccessRule)element;
            return Messages.format(NewWizardMessages.CPListLabelProvider_access_rules_label, new String[]{AccessRulesLabelProvider.getResolutionLabel(rule.getKind()), rule.getPattern().toString()});
        }
        return super.getText(element);
    }

    public String getCPUserLibraryText(BPUserLibraryElement element) {
        String name = element.getName();
        if (element.isSystemLibrary()) {
            name = Messages.format(NewWizardMessages.CPListLabelProvider_systemlibrary, name);
        }
        return name;
    }

    public String getCPListElementAttributeText(BPListElementAttribute attrib) {
        String notAvailable = NewWizardMessages.CPListLabelProvider_none;
        String key = attrib.getKey();
        if (key.equals("exclusion")) {
            String arg = null;
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int patternsCount = 0;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < patterns.length) {
                    String pattern = patterns[i].toString();
                    if (pattern.length() > 0) {
                        if (patternsCount > 0) {
                            buf.append(NewWizardMessages.CPListLabelProvider_exclusion_filter_separator);
                        }
                        buf.append(pattern);
                        ++patternsCount;
                    }
                    ++i;
                }
                arg = patternsCount > 0 ? buf.toString() : notAvailable;
            } else {
                arg = notAvailable;
            }
            return Messages.format(NewWizardMessages.CPListLabelProvider_exclusion_filter_label, new String[]{arg});
        }
        if (key.equals("inclusion")) {
            String arg = null;
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int patternsCount = 0;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < patterns.length) {
                    String pattern = patterns[i].toString();
                    if (pattern.length() > 0) {
                        if (patternsCount > 0) {
                            buf.append(NewWizardMessages.CPListLabelProvider_inclusion_filter_separator);
                        }
                        buf.append(pattern);
                        ++patternsCount;
                    }
                    ++i;
                }
                arg = patternsCount > 0 ? buf.toString() : notAvailable;
            } else {
                arg = NewWizardMessages.CPListLabelProvider_all;
            }
            return Messages.format(NewWizardMessages.CPListLabelProvider_inclusion_filter_label, new String[]{arg});
        }
        if (key.equals("accessrules")) {
            IAccessRule[] rules = (IAccessRule[])attrib.getValue();
            int nRules = rules != null ? rules.length : 0;
            int parentKind = attrib.getParent().getEntryKind();
            if (parentKind == 2) {
                Boolean combined = (Boolean)attrib.getParent().getAttribute("combineaccessrules");
                if (nRules > 0) {
                    if (combined.booleanValue()) {
                        return Messages.format(NewWizardMessages.CPListLabelProvider_project_access_rules_combined, String.valueOf(nRules));
                    }
                    return Messages.format(NewWizardMessages.CPListLabelProvider_project_access_rules_not_combined, String.valueOf(nRules));
                }
                return NewWizardMessages.CPListLabelProvider_project_access_rules_no_rules;
            }
            if (parentKind == 5) {
                if (nRules > 0) {
                    return Messages.format(NewWizardMessages.CPListLabelProvider_container_access_rules, String.valueOf(nRules));
                }
                return NewWizardMessages.CPListLabelProvider_container_no_access_rules;
            }
            if (nRules > 0) {
                return Messages.format(NewWizardMessages.CPListLabelProvider_access_rules_enabled, String.valueOf(nRules));
            }
            return NewWizardMessages.CPListLabelProvider_access_rules_disabled;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add native library support");
        }
        return notAvailable;
    }

    public String getCPListElementText(BPListElement cpentry) {
        IPath path = cpentry.getPath();
        if (path.toString().startsWith("#special#builtin#")) {
            return "(builtins)";
        }
        if (EnvironmentPathUtils.isFull((IPath)path)) {
            path = EnvironmentPathUtils.getLocalPath((IPath)path);
        }
        switch (cpentry.getEntryKind()) {
            case 1: {
                IResource resource = cpentry.getResource();
                if (resource instanceof IContainer) {
                    StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                    IPath linkTarget = cpentry.getLinkTarget();
                    if (linkTarget != null) {
                        buf.append(" - ");
                        buf.append(linkTarget.toOSString());
                    }
                    buf.append(' ');
                    buf.append(this.fClassLabel);
                    if (!resource.exists()) {
                        buf.append(' ');
                        if (cpentry.isMissing()) {
                            buf.append(this.fCreateLabel);
                        } else {
                            buf.append(this.fNewLabel);
                        }
                    }
                    return buf.toString();
                }
                if (ArchiveFileFilter.isArchivePath(path)) {
                    return this.getPathString(path, resource == null);
                }
                if (!cpentry.isExternalFolder()) {
                    return path.makeRelative().toString();
                }
                return path.toString();
            }
            case 2: {
                return path.lastSegment();
            }
            case 5: {
                try {
                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)path, (IScriptProject)cpentry.getScriptProject());
                    if (container != null) {
                        return container.getDescription(cpentry.getScriptProject());
                    }
                    BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer((String)path.segment(0));
                    if (initializer != null) {
                        String description = initializer.getDescription(path, cpentry.getScriptProject());
                        return Messages.format(NewWizardMessages.CPListLabelProvider_unbound_library, description);
                    }
                }
                catch (ModelException modelException) {}
                return path.toString();
            }
            case 3: {
                IResource resource;
                StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                IPath linkTarget = cpentry.getLinkTarget();
                if (linkTarget != null) {
                    buf.append(" - ");
                    buf.append(linkTarget.toOSString());
                }
                if ((resource = cpentry.getResource()) != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.isMissing()) {
                        buf.append(this.fCreateLabel);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                } else if (cpentry.getOrginalPath() == null) {
                    buf.append(' ');
                    buf.append(this.fNewLabel);
                }
                return buf.toString();
            }
        }
        return NewWizardMessages.CPListLabelProvider_unknown_element_label;
    }

    private String getPathString(IPath path, boolean isExternal) {
        if (ArchiveFileFilter.isArchivePath(path)) {
            IPath appendedPath = path.removeLastSegments(1);
            String appended = isExternal ? appendedPath.toOSString() : appendedPath.makeRelative().toString();
            return Messages.format(NewWizardMessages.CPListLabelProvider_twopart, new String[]{path.lastSegment(), appended});
        }
        return isExternal ? path.toOSString() : path.makeRelative().toString();
    }

    private ImageDescriptor getCPListElementBaseImage(BPListElement cpentry) {
        switch (cpentry.getEntryKind()) {
            case 3: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return DLTKPluginImages.getDescriptor("org.eclipse.dltk.ui.packagefolder_obj.gif");
            }
            case 1: {
                return DLTKPluginImages.getDescriptor("org.eclipse.dltk.ui.jar_lsrc_obj.gif");
            }
            case 2: {
                return this.fProjectImage;
            }
            case 5: {
                return DLTKPluginImages.getDescriptor("org.eclipse.dltk.ui.library_obj.gif");
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof BPListElement) {
            BPListElement cpentry = (BPListElement)element;
            Object imageDescriptor = this.getCPListElementBaseImage(cpentry);
            if (imageDescriptor != null) {
                if (cpentry.isMissing()) {
                    imageDescriptor = new ScriptElementImageDescriptor((ImageDescriptor)imageDescriptor, 32, ScriptElementImageProvider.SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)imageDescriptor);
            }
        } else {
            if (element instanceof BPListElementAttribute) {
                String key = ((BPListElementAttribute)element).getKey();
                if (key.equals("exclusion")) {
                    return this.fRegistry.get(DLTKPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB);
                }
                if (key.equals("inclusion")) {
                    return this.fRegistry.get(DLTKPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB);
                }
                if (key.equals("accessrules")) {
                    return this.fRegistry.get(DLTKPluginImages.DESC_OBJS_ACCESSRULES_ATTRIB);
                }
                return null;
            }
            if (element instanceof BPUserLibraryElement) {
                return DLTKPluginImages.getDescriptor("org.eclipse.dltk.ui.library_obj.gif").createImage();
            }
            if (element instanceof IAccessRule) {
                IAccessRule rule = (IAccessRule)element;
                return AccessRulesLabelProvider.getResolutionImage(rule.getKind());
            }
        }
        return null;
    }
}

