/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.dltk.ActiveFoldingEditorTracker;
import org.eclipse.mylyn.internal.dltk.InterestInducingProblemListener;
import org.eclipse.mylyn.internal.dltk.InterestUpdateDeltaListener;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;
import org.eclipse.mylyn.internal.dltk.TypeHistoryManager;
import org.eclipse.mylyn.internal.dltk.ui.DLTKEditingMonitor;
import org.eclipse.mylyn.internal.dltk.ui.DLTKUiUtil;
import org.eclipse.mylyn.internal.dltk.ui.LandmarkMarkerManager;
import org.eclipse.mylyn.internal.dltk.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.internal.dltk.ui.wizards.MylynPreferenceWizard;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MylynDLTKPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.mylyn";
    private static MylynDLTKPlugin INSTANCE;
    private ResourceBundle resourceBundle;
    private ActiveFoldingEditorTracker editorTracker;
    private TypeHistoryManager typeHistoryManager = null;
    private LandmarkMarkerManager landmarkMarkerManager = new LandmarkMarkerManager();
    private InterestInducingProblemListener problemListener = new InterestInducingProblemListener();
    private DLTKEditingMonitor dltkEditingMonitor;
    private InterestUpdateDeltaListener dltkElementChangeListener = new InterestUpdateDeltaListener();

    public MylynDLTKPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initDefaultPrefs();
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    ContextCorePlugin.getContextManager().addListener((AbstractContextListener)MylynDLTKPlugin.this.landmarkMarkerManager);
                    try {
                        MylynDLTKPlugin.this.typeHistoryManager = new TypeHistoryManager();
                        ContextCorePlugin.getContextManager().addListener((AbstractContextListener)MylynDLTKPlugin.this.typeHistoryManager);
                    }
                    catch (Throwable t) {
                        MylynStatusHandler.log(t, "Could not install type history manager, incompatible Eclipse version.");
                    }
                    if (MylynDLTKPlugin.this.getPreferenceStore().getBoolean("org.eclipse.dltk.mylyn.interest.prediction.errors")) {
                        MylynDLTKPlugin.this.problemListener.enable();
                    }
                    MylynDLTKPlugin.this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)MylynDLTKPlugin.this.problemListener);
                    MylynDLTKPlugin.this.dltkEditingMonitor = new DLTKEditingMonitor();
                    MonitorUiPlugin.getDefault().getSelectionMonitors().add(MylynDLTKPlugin.this.dltkEditingMonitor);
                    MylynDLTKPlugin.this.installEditorTracker(workbench);
                    if (!MylynDLTKPlugin.this.getPreferenceStore().contains("org.eclipse.dltk.mylyn.ui.first.run")) {
                        DLTKUiUtil.installContentAssist(DLTKUIPlugin.getDefault().getPreferenceStore(), true);
                    }
                    if (!MylynDLTKPlugin.this.getPreferenceStore().contains("org.eclipse.dltk.mylyn.ui.first.run")) {
                        MylynPreferenceWizard wizard = new MylynPreferenceWizard();
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        if (wizard != null && shell != null && !shell.isDisposed()) {
                            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                            dialog.create();
                            dialog.open();
                            MylynDLTKPlugin.this.getPreferenceStore().putValue("org.eclipse.dltk.mylyn.ui.first.run", "false");
                        }
                    }
                    DLTKCore.addElementChangedListener((IElementChangedListener)MylynDLTKPlugin.this.dltkElementChangeListener);
                }
                catch (Throwable t) {
                    MylynStatusHandler.fail(t, "Mylyn DLTK plug-in initialization failed", true);
                }
            }
        });
    }

    private void initDefaultPrefs() {
        this.getPreferenceStore().setDefault("org.eclipse.dltk.mylyn.interest.prediction.errors", false);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            super.stop(context);
            INSTANCE = null;
            this.resourceBundle = null;
            ContextCorePlugin.getContextManager().removeListener((AbstractContextListener)this.typeHistoryManager);
            ContextCorePlugin.getContextManager().removeListener((AbstractContextListener)this.landmarkMarkerManager);
            MonitorUiPlugin.getDefault().getSelectionMonitors().remove((Object)this.dltkEditingMonitor);
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.dltkElementChangeListener);
        }
        catch (Exception e) {
            MylynStatusHandler.fail(e, "Mylyn DLTK stop terminated abnormally", false);
        }
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new ActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        int j = 0;
        while (j < PlatformUI.getWorkbench().getWorkbenchWindows().length) {
            IWorkbenchWindow w = PlatformUI.getWorkbench().getWorkbenchWindows()[j];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof ScriptEditor) {
                        ScriptEditor editor = (ScriptEditor)part;
                        this.editorTracker.registerEditor(editor);
                        ActiveFoldingListener.resetProjection(editor);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public static MylynDLTKPlugin getDefault() {
        return INSTANCE;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MylynDLTKPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mylyn.java.JavaPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public ActiveFoldingEditorTracker getEditorTracker() {
        return this.editorTracker;
    }
}

