/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;

public class HierarchyScope
extends DLTKSearchScope {
    public IType focusType;
    private String focusPath;
    private WorkingCopyOwner owner;
    private ITypeHierarchy hierarchy;
    private IType[] types;
    private HashSet resourcePaths;
    private IPath[] enclosingProjectsAndZips;
    protected IResource[] elements;
    protected int elementCount;
    public boolean needsRefresh;

    public void add(IResource element) {
        block3: {
            if (this.elementCount == this.elements.length) {
                this.elements = new IResource[this.elementCount * 2];
                System.arraycopy(this.elements, 0, this.elements, 0, this.elementCount);
            }
            this.elements[this.elementCount++] = element;
            IModelElement modelElement = DLTKCore.create(element);
            try {
                this.add(modelElement);
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    public HierarchyScope(IDLTKLanguageToolkit languageToolkit, IType type, WorkingCopyOwner owner) throws ModelException {
        super(languageToolkit);
        this.focusType = type;
        this.owner = owner;
        this.enclosingProjectsAndZips = this.computeProjectsAndZips(type);
        IProjectFragment root = (IProjectFragment)type.getScriptFolder().getParent();
        if (root.isArchive()) {
            String zipFileName;
            IPath jarPath = root.getPath();
            Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), jarPath, true);
            if (target instanceof IFile) {
                zipFileName = jarPath.toString();
            } else if (target instanceof IFileHandle) {
                zipFileName = ((IFileHandle)target).toOSString();
            } else {
                return;
            }
            this.focusPath = String.valueOf(zipFileName) + '|' + type.getFullyQualifiedName().replace('.', '/');
        } else {
            this.focusPath = type.getPath().toString();
        }
        this.needsRefresh = true;
    }

    private void buildResourceVector() {
        HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        this.types = this.hierarchy.getAllTypes();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < this.types.length) {
            block8: {
                IType type;
                block5: {
                    String zipFileName;
                    IPath jarPath;
                    block7: {
                        Object target;
                        block6: {
                            IProjectFragment root;
                            type = this.types[i];
                            IResource resource = type.getResource();
                            if (resource != null && resources.get(resource) == null) {
                                resources.put(resource, resource);
                                this.add(resource);
                            }
                            if (!((root = (IProjectFragment)type.getScriptFolder().getParent()) instanceof ArchiveProjectFragment)) break block5;
                            ArchiveProjectFragment jar = (ArchiveProjectFragment)root;
                            jarPath = jar.getPath();
                            target = Model.getTarget((IContainer)workspaceRoot, jarPath, true);
                            if (!(target instanceof IFile)) break block6;
                            zipFileName = jarPath.toString();
                            break block7;
                        }
                        if (!(target instanceof IFileHandle)) break block8;
                        zipFileName = ((IFileHandle)target).toOSString();
                    }
                    String resourcePath = String.valueOf(zipFileName) + '|' + type.getFullyQualifiedName().replace('.', '/');
                    this.resourcePaths.add(resourcePath);
                    paths.put(jarPath, type);
                    break block8;
                }
                paths.put(type.getScriptProject().getProject().getFullPath(), type);
            }
            ++i;
        }
        this.enclosingProjectsAndZips = new IPath[paths.size()];
        i = 0;
        Iterator iter = paths.keySet().iterator();
        while (iter.hasNext()) {
            this.enclosingProjectsAndZips[i++] = (IPath)iter.next();
        }
    }

    private IPath[] computeProjectsAndZips(IType type) throws ModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IProjectFragment root = (IProjectFragment)type.getScriptFolder().getParent();
        if (root.isArchive()) {
            set.add(root.getPath());
            IPath rootPath = root.getPath();
            Model model = ModelManager.getModelManager().getModel();
            IScriptProject[] projects = model.getScriptProjects();
            HashSet visited = new HashSet();
            int i = 0;
            while (i < projects.length) {
                IScriptProject project2 = projects[i];
                ScriptProject project = (ScriptProject)project2;
                IBuildpathEntry entry = project.getBuildpathEntryFor(rootPath);
                if (entry != null) {
                    IProjectFragment[] roots = project.getAllProjectFragments();
                    set.add(project.getPath());
                    int j = 0;
                    while (j < roots.length) {
                        IProjectFragment pkgFragmentRoot = roots[j];
                        if (pkgFragmentRoot.getKind() == 3) {
                            set.add(pkgFragmentRoot.getPath());
                        }
                        ++j;
                    }
                    this.computeDependents(project, set, visited);
                }
                ++i;
            }
        } else {
            IScriptProject project = (IScriptProject)root.getParent();
            IProjectFragment[] roots = project.getProjectFragments();
            int j = 0;
            while (j < roots.length) {
                IProjectFragment pkgFragmentRoot = roots[j];
                if (pkgFragmentRoot.getKind() == 3) {
                    set.add(pkgFragmentRoot.getPath());
                } else {
                    set.add(pkgFragmentRoot.getParent().getPath());
                }
                ++j;
            }
            this.computeDependents(project, set, new HashSet());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    private void computeDependents(IScriptProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject[] dependents = project.getProject().getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            IProject dependent2 = dependents[i];
            try {
                IScriptProject dependent = DLTKCore.create(dependent2);
                IProjectFragment[] roots = dependent.getProjectFragments();
                set.add(dependent.getPath());
                int j = 0;
                while (j < roots.length) {
                    IProjectFragment pkgFragmentRoot = roots[j];
                    if (pkgFragmentRoot.isArchive()) {
                        set.add(pkgFragmentRoot.getPath());
                    }
                    ++j;
                }
                this.computeDependents(dependent, set, visited);
            }
            catch (ModelException modelException) {}
            ++i;
        }
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex;
        if (this.hierarchy == null) {
            if (resourcePath.equals(this.focusPath)) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (ModelException modelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        if ((separatorIndex = resourcePath.indexOf(124)) != -1) {
            return this.resourcePaths.contains(resourcePath);
        }
        int i = 0;
        while (i < this.elementCount) {
            if (resourcePath.startsWith(this.elements[i].getFullPath().toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(IModelElement element) {
        if (this.hierarchy == null) {
            if (this.focusType.equals(element.getAncestor(7))) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (ModelException modelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        IType type = null;
        if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        if (type != null) {
            if (this.hierarchy.contains(type)) {
                return true;
            }
            IType original = (IType)type.getPrimaryElement();
            if (original != null) {
                return this.hierarchy.contains(original);
            }
        }
        return false;
    }

    public IPath[] enclosingProjectsAndZips() {
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (ModelException modelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndZips;
    }

    protected void initialize() throws ModelException {
        this.resourcePaths = new HashSet();
        this.elements = new IResource[5];
        this.elementCount = 0;
        this.needsRefresh = false;
        if (this.hierarchy == null) {
            this.hierarchy = this.focusType.newTypeHierarchy(this.owner, null);
        } else {
            this.hierarchy.refresh(null);
        }
        this.buildResourceVector();
    }

    public void processDelta(IModelElementDelta delta, int eventType) {
        if (this.needsRefresh) {
            return;
        }
        this.needsRefresh = this.hierarchy == null ? false : ((TypeHierarchy)this.hierarchy).isAffected(delta);
    }

    protected void refresh() throws ModelException {
        this.initialize();
    }

    public String toString() {
        return "HierarchyScope on " + ((ModelElement)((Object)this.focusType)).toStringWithAncestors();
    }
}

