/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.Highlighting;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.PositionUpdater;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;

public class TclSemanticPositionUpdater
extends PositionUpdater {
    private HashSet currentPositions = new HashSet();
    private ISemanticHighlightingExtension[] extensions;

    public TclSemanticPositionUpdater(ISemanticHighlightingExtension[] extensions) {
        this.extensions = extensions;
    }

    private List calculateNewPositions(ISourceModule ast, final SemanticHighlightingPresenter presenter, final Highlighting[] highlightings) {
        ArrayList result;
        block6: {
            result = new ArrayList();
            try {
                ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)ast, null);
                module.traverse(new ASTVisitor(){

                    public boolean visitGeneral(ASTNode node) throws Exception {
                        int i = 0;
                        while (i < TclSemanticPositionUpdater.this.extensions.length) {
                            SemanticHighlightingManager.HighlightedPosition[] poss = TclSemanticPositionUpdater.this.extensions[i].calculatePositions(node, presenter, highlightings);
                            if (poss != null) {
                                int j = 0;
                                while (j < poss.length) {
                                    result.add(poss[j]);
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        return true;
                    }
                });
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return result;
    }

    public PositionUpdater.UpdateResult reconcile(ISourceModule ast, SemanticHighlightingPresenter presenter, Highlighting[] highlightings, List currentPositions) {
        this.currentPositions = new HashSet(currentPositions);
        List calculateNewPositions = this.calculateNewPositions(ast, presenter, highlightings);
        Iterator it = calculateNewPositions.iterator();
        ArrayList addedPositions = new ArrayList();
        HashSet removed = new HashSet(currentPositions);
        while (it.hasNext()) {
            Object o = it.next();
            if (currentPositions.contains(o)) {
                removed.remove(o);
                continue;
            }
            addedPositions.add(o);
        }
        ArrayList removedPositions = new ArrayList(removed);
        this.currentPositions = new HashSet(calculateNewPositions);
        return new PositionUpdater.UpdateResult(addedPositions, removedPositions);
    }
}

