/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.packages;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class FixAllDependenciesActionDelegate
implements IWorkbenchWindowActionDelegate {
    private ISelection selection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        this.processSelectionToElements(this.selection);
    }

    private static Object convertResourceToModelElement(Object o) {
        if (o instanceof IModelElement) {
            return o;
        }
        if (!(o instanceof IResource)) {
            return null;
        }
        IResource res = (IResource)o;
        IProject project = res.getProject();
        if (!DLTKLanguageManager.hasScriptNature((IProject)project)) {
            return null;
        }
        IModelElement element = DLTKCore.create((IResource)res);
        if (element != null && element.getElementType() == 5 && element.exists()) {
            return element;
        }
        return res;
    }

    public static void processResourcesToElements(Object o, Set elements, Set resources) {
        if (o instanceof IResource) {
            HashSet els;
            block16: {
                els = new HashSet();
                ResourceVisitor visitor = new ResourceVisitor(els);
                try {
                    ((IResource)o).accept((IResourceVisitor)visitor);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block16;
                    e.printStackTrace();
                }
            }
            Iterator iterator = els.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                Object eo = FixAllDependenciesActionDelegate.convertResourceToModelElement(object);
                if (eo == null) continue;
                if (eo instanceof IModelElement && !elements.contains(eo)) {
                    IDLTKLanguageToolkit tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)eo));
                    if (tk == null || !tk.getNatureId().equals("org.eclipse.dltk.tcl.core.nature")) continue;
                    elements.add(eo);
                    continue;
                }
                if (!(eo instanceof IResource) || resources.contains(eo)) continue;
                resources.add(eo);
            }
        } else if (o instanceof IModelElement) {
            if (o instanceof IParent) {
                SourceModuleVisitor visitor = new SourceModuleVisitor(elements);
                try {
                    ((IModelElement)o).accept((IModelElementVisitor)visitor);
                }
                catch (ModelException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
            } else if (!(o instanceof ISourceModule)) {
                ISourceModule module = (ISourceModule)((IModelElement)o).getAncestor(5);
                if (elements.contains(module)) {
                    elements.add(module);
                }
            } else if (o instanceof ISourceModule && !elements.contains(o)) {
                elements.add(o);
            }
        }
    }

    protected void processSelectionToElements(ISelection selection) {
        final HashSet elements = new HashSet();
        HashSet resources = new HashSet();
        if (this.selection != null && this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.selection;
            Iterator iterator = sel.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                FixAllDependenciesActionDelegate.processResourcesToElements(o, elements, resources);
            }
        }
        Job job = new Job("Fix pacakge dependencies..."){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Fixing dependencies", elements.size());
                HashMap projectToPackages = new HashMap();
                Iterator iterator = elements.iterator();
                while (iterator.hasNext()) {
                    ISourceModule module = (ISourceModule)iterator.next();
                    ModuleDeclaration declaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module, null, (int)1);
                    this.processModule(projectToPackages, module, declaration);
                    monitor.worked(1);
                }
                Iterator iterator2 = projectToPackages.keySet().iterator();
                while (iterator2.hasNext()) {
                    IScriptProject project = (IScriptProject)iterator2.next();
                    Set values = (Set)projectToPackages.get(project);
                    Set names = InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project);
                    names.addAll(values);
                    if (project == null) continue;
                    InterpreterContainerHelper.setInterpreterContainerDependencies((IScriptProject)project, (Set)names);
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            private void processModule(Map projectToPackages, ISourceModule module, ModuleDeclaration declaration) {
                block2: {
                    try {
                        declaration.traverse(new ASTVisitor(this, module, projectToPackages){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ ISourceModule val$module;
                            private final /* synthetic */ Map val$projectToPackages;
                            {
                                this.this$1 = var1_1;
                                this.val$module = iSourceModule;
                                this.val$projectToPackages = map;
                            }

                            public boolean visit(Statement s) throws Exception {
                                if (s instanceof TclPackageDeclaration) {
                                    TclPackageDeclaration pkg = (TclPackageDeclaration)s;
                                    if (pkg.getStyle() == 2) {
                                        TclPackageDeclaration copy = new TclPackageDeclaration(pkg);
                                        String pkgName = copy.getName();
                                        IScriptProject project = this.val$module.getScriptProject();
                                        if (this.val$projectToPackages.containsKey(project)) {
                                            Set pkgs = (Set)this.val$projectToPackages.get(project);
                                            pkgs.add(pkgName);
                                        } else {
                                            HashSet<String> pkgs = new HashSet<String>();
                                            pkgs.add(pkgName);
                                            this.val$projectToPackages.put(project, pkgs);
                                        }
                                    }
                                    return false;
                                }
                                return super.visit(s);
                            }
                        });
                    }
                    catch (Exception e) {
                        if (!DLTKCore.DEBUG) break block2;
                        e.printStackTrace();
                    }
                }
            }
        };
        HashSet resourcesOnly = new HashSet();
        resourcesOnly.addAll(resources);
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            ISourceModule module = (ISourceModule)iterator.next();
            resourcesOnly.add(module.getResource());
        }
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    private static class ResourceVisitor
    implements IResourceVisitor {
        private Set resources;

        public ResourceVisitor(Set resources) {
            this.resources = resources;
        }

        public boolean visit(IResource resource) {
            if (!this.resources.contains(resource) && resource.getType() == 1) {
                this.resources.add(resource);
                return false;
            }
            return true;
        }
    }

    private static class SourceModuleVisitor
    implements IModelElementVisitor {
        private Set elements;

        public SourceModuleVisitor(Set elements) {
            this.elements = elements;
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 3 && (element instanceof ExternalProjectFragment || element instanceof BuiltinProjectFragment)) {
                return false;
            }
            if (element.getElementType() == 5 && !(element instanceof ExternalSourceModule) && !(element instanceof BuiltinSourceModule) && element.getResource() != null) {
                IDLTKLanguageToolkit tk;
                if (!this.elements.contains(element) && (tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)element)) != null && tk.getNatureId().equals("org.eclipse.dltk.tcl.core.nature")) {
                    this.elements.add(element);
                }
                return false;
            }
            return true;
        }
    }
}

