/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ast;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class TclStatement
extends Statement {
    private List expressions;

    public TclStatement(List expressions) {
        if (!expressions.isEmpty()) {
            Expression first = (Expression)expressions.get(0);
            this.setStart(first.sourceStart());
            Expression last = (Expression)expressions.get(expressions.size() - 1);
            this.setEnd(last.sourceEnd());
        }
        this.expressions = expressions;
    }

    public List getExpressions() {
        return this.expressions;
    }

    public Expression getAt(int index) {
        if (index >= 0 && index < this.expressions.size()) {
            return (Expression)this.expressions.get(index);
        }
        return null;
    }

    public int getCount() {
        return this.expressions.size();
    }

    public int getKind() {
        return 10001;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.expressions != null) {
                int i = 0;
                while (i < this.expressions.size()) {
                    ASTNode node = (ASTNode)this.expressions.get(i);
                    node.traverse(visitor);
                    ++i;
                }
            }
            visitor.endvisit((Statement)this);
        }
    }

    public void printNode(CorePrinter output) {
        if (this.expressions != null) {
            output.formatPrintLn("");
            Iterator i = this.expressions.iterator();
            while (i.hasNext()) {
                ASTNode node = (ASTNode)i.next();
                node.printNode(output);
                output.formatPrintLn(" ");
            }
        }
    }

    public String toString() {
        String value = "";
        if (this.expressions != null) {
            Iterator i = this.expressions.iterator();
            while (i.hasNext()) {
                ASTNode node = (ASTNode)i.next();
                value = String.valueOf(value) + node.toString();
                value = String.valueOf(value) + " ";
            }
        }
        return value;
    }

    public void setExpressions(List asList) {
        this.expressions = asList;
    }
}

