/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.dltk.rhino.dbgp.BreakPoint;

public class BreakPointManager {
    private HashMap fileMap = new HashMap();
    private HashMap ids = new HashMap();
    private HashMap returnNames = new HashMap();
    private HashMap watchpoints = new HashMap();
    private HashMap callNames = new HashMap();

    public void removeBreakPoint(String id) {
        BreakPoint object = (BreakPoint)this.ids.get(id);
        if (object != null) {
            this.removeBreakPoint(object);
        }
    }

    public final void addBreakPoint(BreakPoint point) {
        Cloneable object;
        if (point.isReturn) {
            this.returnNames.put(point.method, point);
        }
        if (point.isCall) {
            this.callNames.put(point.method, point);
        }
        if (point.isWatch) {
            object = (ArrayList)this.watchpoints.get(point.expression);
            if (object == null) {
                object = new ArrayList();
                this.watchpoints.put(point.expression, object);
            }
            ((ArrayList)object).add(point);
        }
        if ((object = (HashMap)this.fileMap.get(point.file)) == null) {
            object = new HashMap();
            this.fileMap.put(point.file, object);
        }
        ((HashMap)object).put(new Integer(point.line), point);
        this.ids.put("p" + point.id, point);
    }

    public void removeBreakPoint(BreakPoint point) {
        HashMap object;
        if (point.isReturn) {
            this.returnNames.remove(point.method);
        }
        if (point.isCall) {
            this.callNames.remove(point.method);
        }
        if (point.isWatch) {
            this.watchpoints.remove(point.expression);
        }
        if ((object = (HashMap)this.fileMap.get(point.file)) == null) {
            return;
        }
        object.remove(new Integer(point.line));
        this.ids.remove("p" + point.id);
    }

    public BreakPoint hit(String sourcePath, int lineNumber) {
        HashMap q = (HashMap)this.fileMap.get(sourcePath);
        if (q == null) {
            return null;
        }
        Integer lnNumber = new Integer(lineNumber);
        BreakPoint point = (BreakPoint)q.get(lnNumber);
        if (point == null) {
            return null;
        }
        ++point.currentHitCount;
        if (point.hitValue > 0) {
            if (point.hitCondition == 1 && point.hitValue >= point.currentHitCount) {
                return null;
            }
            if (point.hitCondition == 2 && point.hitValue != point.currentHitCount) {
                return null;
            }
            if (point.hitCondition == 3 && point.currentHitCount % point.hitValue != 0) {
                return null;
            }
        }
        if (point.isTemporary) {
            q.remove(lnNumber);
        }
        return point;
    }

    public void updateBreakpoint(String id, String newState, String newLine, String hitValue, String hitCondition, String condexpression) {
        BreakPoint p = (BreakPoint)this.ids.get(id);
        if (p != null) {
            if (newState != null) {
                if ((newState = newState.trim()).equals("enabled")) {
                    p.setEnabled(true);
                } else if (newState.equals("disabled")) {
                    p.setEnabled(false);
                }
            }
            if (newLine != null) {
                Integer nl;
                HashMap map = (HashMap)this.fileMap.get(p.file);
                BreakPoint po = (BreakPoint)map.get(nl = new Integer(p.line));
                if (po != p) {
                    System.out.println("Error");
                } else {
                    map.remove(nl);
                    map.put(new Integer(Integer.parseInt(newLine)), p);
                }
            }
            if (hitValue != null) {
                p.hitValue = Integer.parseInt(hitValue);
            }
            if (hitCondition != null) {
                p.setHitCondition(hitCondition);
            }
            if (!p.isWatch) {
                p.expression = condexpression;
            } else {
                p.isModification = condexpression.charAt(condexpression.length() - 1) == '1';
                p.isAccess = condexpression.charAt(condexpression.length() - 2) == '1';
                p.expression = condexpression.substring(0, condexpression.length() - 2);
            }
        }
    }

    public BreakPoint hitEnter(String sn) {
        return (BreakPoint)this.callNames.get(sn);
    }

    public BreakPoint hitExit(String sn) {
        return (BreakPoint)this.returnNames.get(sn);
    }

    public List getWatchPoints(String property) {
        return (List)this.watchpoints.get(property);
    }

    public BreakPoint getBreakpoint(String id) {
        return (BreakPoint)this.ids.get(id);
    }

    public void removeBreakPoints() {
        this.fileMap = new HashMap();
        this.ids = new HashMap();
        this.returnNames = new HashMap();
        this.watchpoints = new HashMap();
        this.callNames = new HashMap();
    }
}

