/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.CopyMoveTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.python.tests.model.TestProgressMonitor;

public class CopyMoveElementsTests
extends CopyMoveTests {
    private static final String[] PYTHON_NATURE = new String[]{"org.eclipse.dltk.python.core.nature"};
    static /* synthetic */ Class class$0;

    public CopyMoveElementsTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        IScriptProject project = this.createScriptProject("BinaryProject", PYTHON_NATURE, new String[]{"src"});
        this.createFile("/BinaryProject/src/X.py", "class X:\n  bar = 0\n  def foo(self): \n      pass\n");
        project.getProject().build(6, null);
        CopyMoveElementsTests.waitForAutoBuild();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createScriptProject("P", PYTHON_NATURE, new String[]{"src", "bin"});
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.model.CopyMoveElementsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void tearDown() throws Exception {
        this.deleteProject("P");
        super.tearDown();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("BinaryProject");
        super.tearDownSuite();
    }

    private ISourceModule getSourceModule(String projectName, String rootPath, String packageName, String className) throws ModelException {
        return this.getSourceModule(projectName, rootPath, (IPath)new Path(String.valueOf(packageName) + className));
    }

    public ISourceModule getSourceModule(String string) {
        return this.getSourceModule(string);
    }

    public void testCopyConstructor() throws CoreException {
        this.createFile("/P/src/X.py", "class Z:\n  def __init__(s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("X");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyConstructorInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def __init__(s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("X");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyField() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, null, null, false);
    }

    public void testCopyFieldForce() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  boolean foo;\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, null, null, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int bar;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, null, null, true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int bar;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyFieldRename() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, null, "bar", false);
    }

    public void testCopyFieldRenameForce() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  boolean bar;\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, null, "bar", true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldRenameForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, null, "bar", true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, null, "bar", false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyFieldSameParent() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.copyPositive((IModelElement)fieldSource, (IModelElement)typeSource, null, "bar", false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldsMultiStatus() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n  Object bar;\n  char[] fred;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        IField[] fieldsSource = typeSource.getFields();
        IModelElement[] dests = new IModelElement[fieldsSource.length];
        int i = 0;
        while (i < dests.length) {
            dests[i] = typeDest;
            ++i;
        }
        dests[1] = fieldsSource[0];
        dests[2] = fieldsSource[0];
        try {
            this.startDeltas();
            boolean e = false;
            try {
                typeDest.getModel().copy((IModelElement[])fieldsSource, dests, null, null, false, null);
            }
            catch (ModelException jme) {
                CopyMoveElementsTests.assertTrue((String)"Should be multistatus", (boolean)jme.getStatus().isMultiStatus());
                CopyMoveElementsTests.assertTrue((String)"Should be an invalid destination", (((IModelStatus)jme.getStatus().getChildren()[0]).getCode() == 978 ? 1 : 0) != 0);
                e = true;
            }
            CopyMoveElementsTests.assertTrue((String)"Should have been an exception", (boolean)e);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tY.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tY[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo[+]: {}");
            IModelElement copy = this.generateHandle((IModelElement)fieldsSource[0], null, (IModelElement)typeDest);
            CopyMoveElementsTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.stopDeltas();
            throw throwable;
        }
        this.stopDeltas();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldsMultiStatusInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n  Object bar;\n  char[] fred;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            IField[] fieldsSource = typeSource.getFields();
            IModelElement[] dests = new IModelElement[fieldsSource.length];
            int i = 0;
            while (i < dests.length) {
                dests[i] = typeDest;
                ++i;
            }
            dests[1] = fieldsSource[0];
            dests[2] = fieldsSource[0];
            this.startDeltas();
            boolean e = false;
            try {
                typeDest.getModel().copy((IModelElement[])fieldsSource, dests, null, null, false, null);
            }
            catch (ModelException jme) {
                CopyMoveElementsTests.assertTrue((String)"Should be multistatus", (boolean)jme.getStatus().isMultiStatus());
                CopyMoveElementsTests.assertTrue((String)"Should be an invalid destination", (((IModelStatus)jme.getStatus().getChildren()[0]).getCode() == 978 ? 1 : 0) != 0);
                e = true;
            }
            CopyMoveElementsTests.assertTrue((String)"Should have been an exception", (boolean)e);
            this.assertDeltas("Unexpected delta", "P2[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tY.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tY[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo[+]: {}");
            IModelElement copy = this.generateHandle((IModelElement)fieldsSource[0], null, (IModelElement)typeDest);
            CopyMoveElementsTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.stopDeltas();
            this.deleteProject("P2");
            throw throwable;
        }
        this.stopDeltas();
        this.deleteProject("P2");
    }

    public void testCopyFieldWithCollision() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  boolean foo;\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyNegative((IModelElement)fieldSource, (IModelElement)typeDest, null, null, false, 977);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldWithCollisionInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int bar;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyNegative((IModelElement)fieldSource, (IModelElement)typeDest, null, null, false, 977);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyFieldWithInvalidDestination() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        ISourceModule cf = this.getSourceModule("P", "/BinaryProject/bin", "", "X.class");
        this.copyNegative((IModelElement)fieldSource, (IModelElement)cf.getType("X"), null, null, false, 978);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldWithInvalidDestinationInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            ISourceModule cf = this.getSourceModule("P2", "/BinaryProject/bin", "", "X.class");
            this.copyNegative((IModelElement)fieldSource, (IModelElement)cf.getType("X"), null, null, false, 978);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyFieldWithInvalidPositioning() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyNegative((IModelElement)fieldSource, (IModelElement)typeDest, (IModelElement)typeDest.getField("invalid"), null, false, 993);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldWithInvalidPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyNegative((IModelElement)fieldSource, (IModelElement)typeDest, (IModelElement)typeDest.getField("invalid"), null, false, 993);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyFieldWithPositioning() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  boolean bar;\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, (IModelElement)typeDest.getField("bar"), null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyFieldWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)fieldSource, (IModelElement)typeDest, (IModelElement)typeDest.getField("bar"), null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyInnerTypeWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  class Inner {\n  }    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X").getType("Inner");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def foo(self):\n    pass");
            ISourceModule cuDest = this.getSourceModule("/P2/src/Y.py");
            IType typeDest = cuDest.getType("Y");
            this.copyPositive((IModelElement)typeSource, (IModelElement)typeDest, (IModelElement)typeDest.getMethod("foo"), null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyMainType() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        ISourceModule cuDest = this.getSourceModule("/P/src/Y.py");
        this.copyPositive((IModelElement)typeSource, (IModelElement)cuDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyMainTypeInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            ISourceModule cuDest = this.getSourceModule("/P2/src/Y.py");
            this.copyPositive((IModelElement)typeSource, (IModelElement)cuDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyMethod() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
    }

    public void testCopyMethodForce() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyMethodForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyMethodInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyMethodRename() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, "bar", false);
    }

    public void testCopyMethodRenameForce() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  void bar(String s) {\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, "bar", true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyMethodRenameForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def bar(self, s):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, "bar", true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyMethodRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, "bar", false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyMethodSameParent() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.copyPositive((IModelElement)methodSource, (IModelElement)typeSource, null, "bar", false);
    }

    public void testCopyMethodWithCollision() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyNegative((IModelElement)methodSource, (IModelElement)typeDest, null, null, false, 977);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyMethodWithCollisionInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyNegative((IModelElement)methodSource, (IModelElement)typeDest, null, null, false, 977);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyMethodWithInvalidDestination() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.copyNegative((IModelElement)methodSource, (IModelElement)methodSource, null, null, false, 978);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyMethodWithInvalidDestinationInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def bar(self):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            IMethod methodDest = typeDest.getMethod("bar");
            this.copyNegative((IModelElement)methodSource, (IModelElement)methodDest, null, null, false, 978);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyMethodWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar() {\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, (IModelElement)typeDest.getMethod("bar"), null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyMoveWithInvalidRenamings() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  public void foo() {\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.copyNegative(new IModelElement[]{methodSource}, new IModelElement[]{typeSource}, null, new String[]{"bar", "fred"}, false, 980);
    }

    public void testCopySyntaxErrorMethod() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s:\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopySyntaxErrorMethodInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s:\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.copyPositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testCopyType() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n    pass\nclass Z:\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("Z");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        ISourceModule cuDest = this.getSourceModule("/P/src/Y.py");
        this.copyPositive((IModelElement)typeSource, (IModelElement)cuDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyTypeInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n    pass\nclass Z:\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("Z");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            ISourceModule cuDest = this.getSourceModule("/P2/src/Y.py");
            this.copyPositive((IModelElement)typeSource, (IModelElement)cuDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyTypeWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n    pass\nclass Z:\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("Z");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            ISourceModule cuDest = this.getSourceModule("/P2/src/Y.py");
            this.copyPositive((IModelElement)typeSource, (IModelElement)cuDest, (IModelElement)cuDest.getType("Y"), null, false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveConstructor() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def __init__(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("X");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
        CopyMoveElementsTests.assertTrue((String)"Constructor was not renamed", (boolean)typeDest.getMethod("Y").exists());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveConstructorInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def __init__(s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("X");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
            CopyMoveElementsTests.assertTrue((String)"Constructor was not renamed", (boolean)typeDest.getMethod("Y").exists());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveField() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, null, null, false);
    }

    public void testMoveFieldForce() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  boolean foo;\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, null, null, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveFieldForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int bar;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, null, null, true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveFieldInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int bar;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveFieldRename() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, null, "fred", false);
    }

    public void testMoveFieldRenameForce() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  boolean bar;\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, null, "bar", true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveFieldRenameForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, null, "bar", true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveFieldRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, null, "bar", false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveFieldRenameForceWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n  char fred;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, (IModelElement)typeDest.getField("bar"), "fred", true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveFieldSameParent() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.movePositive((IModelElement)fieldSource, (IModelElement)typeSource, null, "bar", false);
    }

    public void testMoveFieldWithCollision() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  boolean foo;\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.moveNegative((IModelElement)fieldSource, (IModelElement)typeDest, null, null, false, 977);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveFieldWithCollisionInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int bar;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("bar");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.moveNegative((IModelElement)fieldSource, (IModelElement)typeDest, null, null, false, 977);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveFieldWithInvalidDestination() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IField fieldSource = typeSource.getField("foo");
        ISourceModule cf = this.getSourceModule("P", "/BinaryProject/bin", "", "X.class");
        this.moveNegative((IModelElement)fieldSource, (IModelElement)cf.getType("X"), null, null, false, 978);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveFieldWithInvalidDestinationInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            ISourceModule cf = this.getSourceModule("P2", "/BinaryProject/bin", "", "X.class");
            this.moveNegative((IModelElement)fieldSource, (IModelElement)cf.getType("X"), null, null, false, 978);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveFieldWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  int foo;\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IField fieldSource = typeSource.getField("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  boolean bar;\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)fieldSource, (IModelElement)typeDest, (IModelElement)typeDest.getField("bar"), null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveInnerTypeRenameWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  class Inner {\n  }    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X").getType("Inner");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  void foo(self):\n    pass");
            ISourceModule cuDest = this.getSourceModule("/P2/src/Y.py");
            IType typeDest = cuDest.getType("Y");
            this.movePositive((IModelElement)typeSource, (IModelElement)typeDest, (IModelElement)typeDest.getMethod("foo"), "T", false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveInnerTypeWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  class Inner:\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X").getType("Inner");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def foo(self):\n    pass");
            ISourceModule cuDest = this.getSourceModule("/P2/src/Y.py");
            IType typeDest = cuDest.getType("Y");
            this.movePositive((IModelElement)typeSource, (IModelElement)typeDest, (IModelElement)typeDest.getMethod("foo"), null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveMainTypes() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n    pass");
        IScriptFolder pkg = this.getPackage("/P/src");
        ISourceModule cu = pkg.getSourceModule("X.py");
        IType typeSource = cu.getType("X");
        this.movePositive(new IModelElement[]{typeSource}, new IModelElement[]{cu}, null, new String[]{"Y"}, false);
        ISourceModule renamedCU = pkg.getSourceModule("Y.py");
        CopyMoveElementsTests.assertTrue((String)"Renamed element should be present", (boolean)renamedCU.getType("Y").exists());
    }

    public void testMoveMethod() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
    }

    public void testMoveMethodForce() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveMethodRename() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, "bar", false);
    }

    public void testMoveMethodRenameForce() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  void bar(String s) {\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, "bar", true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodRenameForceInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  void bar(String s) {\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, "bar", true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodRenameInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, "bar", false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodRenameWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def bar(self):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, (IModelElement)typeDest.getMethod("bar"), "fred", false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveMethodSameParent() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.movePositive((IModelElement)methodSource, (IModelElement)typeSource, null, "bar", false);
    }

    public void testMoveMethodsWithCancel() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass\n  def bar(self):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        this.createFile("/P/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        boolean isCanceled = false;
        try {
            TestProgressMonitor monitor = TestProgressMonitor.getInstance();
            monitor.setCancelledCounter(1);
            this.movePositive((IModelElement[])typeSource.getMethods(), new IModelElement[]{typeDest}, null, null, false, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            isCanceled = true;
        }
        CopyMoveElementsTests.assertTrue((String)"Operation should have thrown an operation canceled exception", (boolean)isCanceled);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodsWithCancelInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass\n  def bar(self):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            boolean isCanceled = false;
            try {
                TestProgressMonitor monitor = TestProgressMonitor.getInstance();
                monitor.setCancelledCounter(1);
                this.movePositive((IModelElement[])typeSource.getMethods(), new IModelElement[]{typeDest}, null, null, false, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                isCanceled = true;
            }
            CopyMoveElementsTests.assertTrue((String)"Operation should have thrown an operation canceled exception", (boolean)isCanceled);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveMethodWithCollision() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.moveNegative((IModelElement)methodSource, (IModelElement)typeDest, null, null, false, 977);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodWithCollisionInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def foo(self, s):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.moveNegative((IModelElement)methodSource, (IModelElement)typeDest, null, null, false, 977);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveMethodWithInvalidDestination() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.moveNegative((IModelElement)methodSource, (IModelElement)methodSource, null, null, false, 978);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodWithInvalidDestinationInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def bar(self):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            IMethod methodDest = typeDest.getMethod("bar");
            this.moveNegative((IModelElement)methodSource, (IModelElement)methodDest, null, null, false, 978);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveMethodWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s):\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n  def bar(self):\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, (IModelElement)typeDest.getMethod("bar"), null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    public void testMoveSyntaxErrorMethod() throws CoreException {
        this.createFile("/P/src/X.py", "class X:\n  def foo(self, s:\n    pass");
        IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
        IMethod methodSource = typeSource.getMethod("foo");
        this.createFile("/P/src/Y.py", "class Y:\n    pass");
        IType typeDest = this.getSourceModule("/P/src/Y.py").getType("Y");
        this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveSyntaxErrorMethodInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n  def foo(self, s:\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("X");
            IMethod methodSource = typeSource.getMethod("foo");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            IType typeDest = this.getSourceModule("/P2/src/Y.py").getType("Y");
            this.movePositive((IModelElement)methodSource, (IModelElement)typeDest, null, null, false);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveTypeRenameWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n    pass\nclass Z:\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("Z");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            ISourceModule cuDest = this.getSourceModule("/P2/src/Y.py");
            this.movePositive((IModelElement)typeSource, (IModelElement)cuDest, (IModelElement)cuDest.getType("Y"), "T", false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveTypeWithPositioningInDifferentProject() throws CoreException {
        try {
            this.createFile("/P/src/X.py", "class X:\n    pass\nclass Z:\n    pass");
            IType typeSource = this.getSourceModule("/P/src/X.py").getType("Z");
            this.createScriptProject("P2", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("/P2/src/Y.py", "class Y:\n    pass");
            ISourceModule cuDest = this.getSourceModule("/P2/src/Y.py");
            this.movePositive((IModelElement)typeSource, (IModelElement)cuDest, (IModelElement)cuDest.getType("Y"), null, false);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P2");
    }
}

