/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;

public class DeleteResourcesTests
extends ModifyingResourceTests {
    private static final String[] PYTHON_NATURE = new String[]{"org.eclipse.dltk.python.core.nature"};
    static /* synthetic */ Class class$0;

    public DeleteResourcesTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createScriptProject("P", PYTHON_NATURE, new String[]{""});
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.deleteProject("P");
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.model.DeleteResourcesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSourceModule1() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n    pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            this.startDeltas();
            DeleteResourcesTests.assertTrue((String)"Resource should exists!", (boolean)cu.exists());
            cu.delete(false, null);
            DeleteResourcesTests.assertTrue((String)"Should be able to delete a CU", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[-]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSourceModule2() throws CoreException {
        try {
            IFile file = this.createFile("P/X.py", "class X:\n    pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            this.startDeltas();
            file.delete(false, null);
            DeleteResourcesTests.assertTrue((String)"Should be able to delete a CU", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSourceModule3() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n    pass");
            final ISourceModule cu = this.getSourceModule("P/X.py");
            cu.open(null);
            this.startDeltas();
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    cu.delete(true, null);
                    DeleteResourcesTests.assertTrue((String)"Should be able to delete a CU", (!cu.exists() ? 1 : 0) != 0);
                }
            }, null);
            DeleteResourcesTests.assertTrue((String)"Should be able to delete a CU", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[-]: {}");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSourceModule4() throws CoreException {
        try {
            this.createFolder("P/p");
            IFile file = this.createFile("P/p/X.py", "package p;\nclass X:\n    pass");
            ISourceModule cu = this.getSourceModule("P/p/X.py");
            this.startDeltas();
            cu.delete(false, null);
            DeleteResourcesTests.assertTrue((String)"CU should not exist", (!cu.exists() ? 1 : 0) != 0);
            DeleteResourcesTests.assertTrue((String)"Corresponding file should not exist", (!file.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[*]: {CHILDREN}\n\t\t\tX.py[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFolder("P/p");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFolder("P/p");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteEmptyScriptFolder() throws CoreException {
        try {
            this.createFolder("P/p1/p2");
            IScriptFolder pkg = this.getPackage("P/p1");
            IFolder folder = this.getFolder("P/p1");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteResourcesTests.assertTrue((String)"Folder should exist", (boolean)folder.exists());
            DeleteResourcesTests.assertTrue((String)"Fragment should exist", (boolean)pkg.exists());
            this.assertDeltas("Unexpected delta", "");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFolder("P/p1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFolder("P/p1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteScriptFolder1() throws CoreException {
        try {
            this.createFolder("P/a/b/c");
            this.createFile("P/a/b/c/X.py", "class X:\n    pass");
            IScriptFolder pkg = this.getPackage("P/a/b/c");
            IFolder folder = this.getFolder("P/a/b/c");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteResourcesTests.assertTrue((String)"Folder should not exist", (!folder.exists() ? 1 : 0) != 0);
            DeleteResourcesTests.assertTrue((String)"Fragment should not exist", (!pkg.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\ta/b/c[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFolder("P/p1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFolder("P/p1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteScriptFolder2() throws CoreException {
        try {
            this.createScriptProject("P1", PYTHON_NATURE, new String[]{"src", "bin"});
            IFile file = this.createFile("P1/src/X.py", "class X:\n    pass");
            IScriptFolder pkg = this.getPackage("P1/src");
            IFolder folder = this.getFolder("P1/src");
            ISourceModule cu = this.getSourceModule("P1/src/X.py");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteResourcesTests.assertTrue((String)"Folder should still exist", (boolean)folder.exists());
            DeleteResourcesTests.assertTrue((String)"Fragment should still exist", (boolean)pkg.exists());
            DeleteResourcesTests.assertTrue((String)"File should no longer exist", (!file.exists() ? 1 : 0) != 0);
            DeleteResourcesTests.assertTrue((String)"Compilation unit should no longer exist", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[-]: {}");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteScriptFolder3() throws CoreException {
        try {
            this.createScriptProject("P1", PYTHON_NATURE, new String[]{""});
            IFile file = this.createFile("P1/X.py", "class X:\n    pass");
            IScriptFolder pkg = this.getPackage("P1");
            IProject project = this.getProject("P1");
            ISourceModule cu = this.getSourceModule("P1/X.py");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteResourcesTests.assertTrue((String)"Project should still exist", (boolean)project.exists());
            DeleteResourcesTests.assertTrue((String)"Fragment should still exist", (boolean)pkg.exists());
            DeleteResourcesTests.assertTrue((String)"File should no longer exist", (!file.exists() ? 1 : 0) != 0);
            DeleteResourcesTests.assertTrue((String)"Compilation unit should no longer exist", (!cu.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[-]: {}");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteScriptFolder4() throws CoreException {
        try {
            this.createScriptProject("P1", PYTHON_NATURE, new String[]{""});
            IFolder folder = this.createFolder("P1/p");
            IFile file = this.createFile("P1/p/X.class", "");
            IScriptFolder pkg = this.getPackage("P1/p");
            this.startDeltas();
            pkg.delete(false, null);
            DeleteResourcesTests.assertTrue((String)"Folder should no longer exist", (!folder.exists() ? 1 : 0) != 0);
            DeleteResourcesTests.assertTrue((String)"Fragment should no longer exist", (!pkg.exists() ? 1 : 0) != 0);
            DeleteResourcesTests.assertTrue((String)"File should no longer exist", (!file.exists() ? 1 : 0) != 0);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tp[-]: {}");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
    }

    private void assertDeletion(IModelElement element) throws ModelException {
        this.assertDeletion(new IModelElement[]{element});
    }
}

