/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.model;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.internal.core.util.Util;

public class EncodingTests
extends ModifyingResourceTests {
    private static final String[] PYTHON_NATURE = new String[]{"org.eclipse.dltk.python.core.nature"};
    IProject encodingProject;
    IScriptProject encodingScriptProject;
    IFile utf8File;
    ISourceReference utf8Source;
    private boolean setUpSuite;
    static String InterpreterEncoding;
    static String wkspEncoding;
    static /* synthetic */ Class class$0;

    static {
        wkspEncoding = InterpreterEncoding = System.getProperty("file.encoding");
    }

    public EncodingTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.model.EncodingTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void setUpSuite() throws Exception {
        this.setUpSuite = true;
        super.setUpSuite();
    }

    public void tearDownSuite() throws Exception {
        this.setUpSuite = false;
        super.tearDownSuite();
    }

    protected void setUp() throws Exception {
        super.setUp();
        wkspEncoding = this.getWorkspaceRoot().getDefaultCharset();
        this.encodingScriptProject = this.setUpScriptProject("Encoding");
        this.encodingProject = (IProject)this.encodingScriptProject.getResource();
        this.utf8File = (IFile)this.encodingProject.findMember("src/testUTF8/Test.py");
    }

    protected void tearDown() throws Exception {
        this.encodingProject.setDefaultCharset(null, null);
        if (this.utf8File.exists()) {
            this.utf8File.setCharset(null, null);
        }
        if (this.utf8Source != null) {
            ((IOpenable)this.utf8Source).close();
        }
        this.encodingScriptProject.close();
        this.getWorkspaceRoot().setDefaultCharset(null, null);
        this.deleteProject("Encoding");
        super.tearDown();
    }

    void compareContents(ISourceModule cu, String encoding) throws ModelException {
        this.compareContents(cu, encoding, false);
    }

    void compareContents(ISourceModule cu, String encoding, boolean bom) throws ModelException {
        String source = cu.getSource();
        String systemSourceRenamed = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)source);
        IFile file = (IFile)cu.getUnderlyingResource();
        String renamedContents = new String(Util.getResourceContentsAsCharArray((IFile)file));
        renamedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)renamedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)renamedContents, (String)systemSourceRenamed);
        byte[] renamedSourceBytes = null;
        try {
            renamedSourceBytes = source.getBytes(encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        EncodingTests.assertNotNull((String)("Unsupported encoding: " + encoding), (Object)renamedSourceBytes);
        byte[] renamedEncodedBytes = Util.getResourceContentsAsByteArray((IFile)file);
        int start = bom ? IContentDescription.BOM_UTF_8.length : 0;
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)(renamedEncodedBytes.length - start), (int)renamedSourceBytes.length);
        int i = 0;
        int max = renamedSourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (renamedSourceBytes[i] == renamedEncodedBytes[i + start] ? 1 : 0) != 0);
            ++i;
        }
    }

    public boolean convertToIndependantLineDelimiter(File file) {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateSourceModuleAndImportContainer() throws ModelException, CoreException {
        String savedEncoding = null;
        try {
            Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            savedEncoding = preferences.getString("encoding");
            String encoding = "UTF-8";
            preferences.setValue("encoding", encoding);
            ResourcesPlugin.getPlugin().savePluginPreferences();
            IScriptProject newProject = this.createScriptProject("P", PYTHON_NATURE, new String[]{""});
            IScriptFolder pkg = this.getScriptFolder("P", "", (IPath)new Path(""));
            String source = "class A:\r\n\tdef main(*args) :\r\n\t\tprint(\"\u00e9\");\r\n";
            ISourceModule cu = pkg.createSourceModule("A.py", source, false, (IProgressMonitor)new NullProgressMonitor());
            this.assertCreation((IModelElement)cu);
            cu.rename("B.py", true, (IProgressMonitor)new NullProgressMonitor());
            cu = pkg.getSourceModule("B.py");
            cu.rename("A.py", true, (IProgressMonitor)new NullProgressMonitor());
            cu = pkg.getSourceModule("A.py");
            byte[] tab = null;
            try {
                tab = cu.getSource().getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            byte[] encodedContents = Util.getResourceContentsAsByteArray((IFile)newProject.getProject().getWorkspace().getRoot().getFile(cu.getPath()));
            EncodingTests.assertEquals((String)"wrong size of encoded string", (int)tab.length, (int)encodedContents.length);
            int i = 0;
            int max = tab.length;
            while (i < max) {
                EncodingTests.assertTrue((String)("wrong size of encoded character at" + i), (tab[i] == encodedContents[i] ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.deleteProject("P");
            Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
            preferences.setValue("encoding", savedEncoding);
            ResourcesPlugin.getPlugin().savePluginPreferences();
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        this.deleteProject("P");
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("encoding", savedEncoding);
        ResourcesPlugin.getPlugin().savePluginPreferences();
    }

    public void test001() throws ModelException, CoreException, UnsupportedEncodingException {
        String encoding = "UTF-8";
        this.utf8File.setCharset(encoding, null);
        Assert.assertTrue((String)"", (boolean)this.utf8File.exists());
        this.utf8Source = this.getSourceModule(this.utf8File.getFullPath().toString());
        String source = this.utf8Source.getSource();
        String systemSource = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(encoding);
        byte[] encodedBytes = Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
        int i = 0;
        int max = sourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test002() throws ModelException, CoreException, UnsupportedEncodingException {
        String encoding = "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        this.utf8Source = this.getSourceModule(this.utf8File.getFullPath().toString());
        String source = this.utf8Source.getSource();
        String systemSource = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(encoding);
        byte[] encodedBytes = Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
        int i = 0;
        int max = sourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test003() throws ModelException, CoreException, UnsupportedEncodingException {
        this.utf8Source = this.getSourceModule(this.utf8File.getFullPath().toString());
        String source = this.utf8Source.getSource();
        String systemSource = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(wkspEncoding);
        byte[] encodedBytes = Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
    }

    public void test004() throws ModelException, CoreException {
        String encoding = "UTF-8".equals(InterpreterEncoding) ? "Cp1252" : "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getSourceModule(this.utf8File.getFullPath().toString());
        String source = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)InterpreterEncoding));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test005() throws ModelException, CoreException {
        String encoding = "UTF-8".equals(InterpreterEncoding) ? "Cp1252" : "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        this.utf8Source = this.getSourceModule(this.utf8File.getFullPath().toString());
        String source = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)InterpreterEncoding));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test006() throws ModelException, CoreException {
        String encoding = wkspEncoding.equals(InterpreterEncoding) ? ("UTF-8".equals(wkspEncoding) ? "Cp1252" : "UTF-8") : InterpreterEncoding;
        this.utf8Source = this.getSourceModule(this.utf8File.getFullPath().toString());
        String source = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)encoding));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test011() throws ModelException, CoreException, UnsupportedEncodingException {
        String encoding = "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = this.utf8Source.getSource();
        String systemSource = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(encoding);
        byte[] encodedBytes = Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
        int i = 0;
        int max = sourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    private ISourceReference getClassFile(String string, String string2, String string3, String string4) throws ModelException {
        return this.getSourceModule(string, string2, String.valueOf(string3) + "/" + string4);
    }

    public void test012() throws ModelException, CoreException, UnsupportedEncodingException {
        String encoding = "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = this.utf8Source.getSource();
        String systemSource = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(encoding);
        byte[] encodedBytes = Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
        int i = 0;
        int max = sourceBytes.length;
        while (i < max) {
            EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void test013() throws ModelException, CoreException, UnsupportedEncodingException {
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = this.utf8Source.getSource();
        String systemSource = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)systemSource);
        byte[] sourceBytes = source.getBytes(wkspEncoding);
        byte[] encodedBytes = Util.getResourceContentsAsByteArray((IFile)this.utf8File);
        EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
    }

    public void test014() throws ModelException, CoreException {
        String encoding = "UTF-8".equals(InterpreterEncoding) ? "Cp1252" : "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)InterpreterEncoding));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test015() throws ModelException, CoreException {
        String encoding = "UTF-8".equals(InterpreterEncoding) ? "Cp1252" : "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        this.utf8Source = this.getClassFile("Encoding", "bins", "testUTF8", "Test.class");
        String source = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)InterpreterEncoding));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test016() throws ModelException, CoreException {
        String encoding = wkspEncoding.equals(InterpreterEncoding) ? ("UTF-8".equals(wkspEncoding) ? "Cp1252" : "UTF-8") : InterpreterEncoding;
        this.utf8Source = this.getSourceModule("Encoding", "bins", "testUTF8/Test.class");
        String source = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)this.utf8Source.getSource());
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)encoding));
        encodedContents = org.eclipse.dltk.core.tests.util.Util.convertToIndependantLineDelimiter((String)encodedContents);
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test021() throws ModelException, CoreException {
        IProjectFragment root = this.getProjectFragment("Encoding", "testUTF8.jar");
        this.utf8Source = root.getScriptFolder("testUTF8").getSourceModule("Test.class");
        EncodingTests.assertNotNull((Object)this.utf8Source);
        String source = this.utf8Source.getSource();
        EncodingTests.assertNotNull((Object)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)InterpreterEncoding));
        this.assertSourceEquals("Encoded UTF-8 source should have been decoded the same way!", source, encodedContents);
    }

    public void test022() throws ModelException, CoreException {
        String encoding = "UTF-8".equals(InterpreterEncoding) ? "Cp1252" : "UTF-8";
        this.encodingProject.setDefaultCharset(encoding, null);
        IProjectFragment root = this.getProjectFragment("Encoding", "testUTF8.jar");
        this.utf8Source = root.getScriptFolder("testUTF8").getSourceModule("Test.class");
        EncodingTests.assertNotNull((Object)this.utf8Source);
        String source = this.utf8Source.getSource();
        EncodingTests.assertNotNull((Object)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)encoding));
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
    }

    public void test023() throws ModelException, CoreException {
        String encoding = "UTF-8".equals(InterpreterEncoding) ? "Cp1252" : "UTF-8";
        IFile zipFile = (IFile)this.encodingProject.findMember("testUTF8.zip");
        EncodingTests.assertNotNull((String)"Cannot find class file!", (Object)zipFile);
        zipFile.setCharset(encoding, null);
        IProjectFragment root = this.getProjectFragment("Encoding", "testUTF8.jar");
        this.utf8Source = root.getScriptFolder("testUTF8").getSourceModule("Test.class");
        EncodingTests.assertNotNull((Object)this.utf8Source);
        String source = this.utf8Source.getSource();
        EncodingTests.assertNotNull((Object)source);
        String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)this.utf8File, (String)encoding));
        EncodingTests.assertFalse((String)"Sources should not be the same as they were decoded with different encoding!", (boolean)encodedContents.equals(source));
        zipFile.setCharset(null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test030() throws ModelException, CoreException {
        Object workingCopy = null;
        try {
            try {
                String encoding = "UTF-8";
                this.createScriptProject("P", PYTHON_NATURE, new String[]{""});
                String initialContent = "/**\n */\npublic class Test {}";
                IFile file = this.createFile("P/Test.py", initialContent);
                file.setCharset(encoding, null);
                ISourceModule cu = this.getSourceModule("P/Test.py");
                String firstModif = "/**\n * Caract?res exotiques:\n * ?|#|?|?|?|?|?|?|?|?|??\n */\npublic class Test {}";
                cu.getBuffer().setContents(firstModif);
                cu.getBuffer().save(null, true);
                String source = cu.getBuffer().getContents();
                String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)file, (String)encoding));
                EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)source);
                byte[] sourceBytes = source.getBytes(encoding);
                byte[] encodedBytes = Util.getResourceContentsAsByteArray((IFile)file);
                EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
                int i = 0;
                int max = sourceBytes.length;
                while (i < max) {
                    EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
                    ++i;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.stopDeltas();
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.stopDeltas();
        if (workingCopy != null) {
            workingCopy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test031() throws ModelException, CoreException {
        ISourceModule workingCopy = null;
        try {
            try {
                String encoding = "UTF-8";
                this.createScriptProject("P", PYTHON_NATURE, new String[]{""});
                String initialContent = "/**\n */\npublic class Test {}";
                IFile file = this.createFile("P/Test.py", initialContent);
                file.setCharset(encoding, null);
                ISourceModule cu = this.getSourceModule("P/Test.py");
                workingCopy = cu.getWorkingCopy(null);
                String secondModif = "/**\n * Caract?res exotiques:\n * ?|#|?|?|?|?|?|?|?|?|??\n * Autres caract?res exotiques:\n * ?|?|?|?|?|?\n */\npublic class Test {}";
                workingCopy.getBuffer().setContents(secondModif);
                workingCopy.commitWorkingCopy(true, null);
                String source = workingCopy.getBuffer().getContents();
                String encodedContents = new String(Util.getResourceContentsAsCharArray((IFile)file));
                EncodingTests.assertEquals((String)"Encoded UTF-8 source should have been decoded the same way!", (String)encodedContents, (String)source);
                byte[] sourceBytes = source.getBytes(encoding);
                byte[] encodedBytes = Util.getResourceContentsAsByteArray((IFile)file);
                EncodingTests.assertEquals((String)"Wrong size of encoded string", (int)encodedBytes.length, (int)sourceBytes.length);
                int i = 0;
                int max = sourceBytes.length;
                while (i < max) {
                    EncodingTests.assertTrue((String)("Wrong size of encoded character at " + i), (sourceBytes[i] == encodedBytes[i] ? 1 : 0) != 0);
                    ++i;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.stopDeltas();
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.stopDeltas();
        if (workingCopy != null) {
            workingCopy.discardWorkingCopy();
        }
        this.deleteProject("P");
    }

    public void test032() throws ModelException, CoreException {
        String encoding = "UTF-8";
        this.utf8File.setCharset(encoding, null);
        this.utf8Source = this.getSourceModule(this.utf8File.getFullPath().toString());
        String source = this.utf8Source.getSource();
        IFile bomFile = (IFile)this.encodingProject.findMember("src/testUTF8BOM/Test.py");
        ISourceModule bomSourceRef = this.getSourceModule(bomFile.getFullPath().toString());
        String bomSource = bomSourceRef.getSource();
        EncodingTests.assertEquals((String)"BOM UTF-8 source should be idtentical than UTF-8!", (String)source, (String)bomSource);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug66898() throws ModelException, CoreException {
        String encoding = "UTF-8".equals(InterpreterEncoding) ? "Cp1252" : "UTF-8";
        IFile file = (IFile)this.encodingProject.findMember("src/testBug66898/Test.py");
        file.setCharset(encoding, null);
        String fileName = file.getName();
        ISourceModule cu = this.getSourceModule(file.getFullPath().toString());
        this.createFolder("/Encoding/src/tmp");
        IScriptFolder packFrag = this.getScriptFolder("Encoding", "src", (IPath)new Path("tmp"));
        try {
            cu.move((IModelElement)packFrag, null, null, false, null);
            ISourceModule destSource = packFrag.getSourceModule(fileName);
            IFile destFile = (IFile)destSource.getUnderlyingResource();
            EncodingTests.assertEquals((String)"Moved file should keep encoding", (String)encoding, (String)destFile.getCharset());
            this.compareContents(destSource, encoding);
            destSource.rename("TestUTF8.py", false, null);
            ISourceModule renamedSource = packFrag.getSourceModule("TestUTF8.py");
            IFile renamedFile = (IFile)renamedSource.getUnderlyingResource();
            EncodingTests.assertEquals((String)"Moved file should keep encoding", (String)encoding, (String)renamedFile.getCharset());
            this.compareContents(renamedSource, encoding);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.deleteFolder("/Encoding/src/tmp");
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        this.deleteFolder("/Encoding/src/tmp");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug66898b() throws ModelException, CoreException {
        final String encoding = "UTF-8".equals(InterpreterEncoding) ? "Cp1252" : "UTF-8";
        final IFile file = (IFile)this.encodingProject.findMember("src/testBug66898b/Test.py");
        file.setCharset(encoding, null);
        final String fileName = file.getName();
        final IScriptFolder srcFolder = this.getScriptFolder("Encoding", "src", "testBug66898b");
        this.createFolder("/Encoding/src/tmp");
        final IScriptFolder tmpFolder = this.getScriptFolder("Encoding", "src", "tmp");
        try {
            IWorkspaceRunnable copy = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ISourceModule cu = EncodingTests.this.getSourceModule(file.getFullPath().toString());
                    cu.copy((IModelElement)tmpFolder, null, null, true, null);
                    cu.close();
                    ISourceModule dest = tmpFolder.getSourceModule(fileName);
                    IFile destFile = (IFile)dest.getUnderlyingResource();
                    EncodingTests.assertEquals((String)"Copied file should keep encoding", (String)encoding, (String)destFile.getCharset());
                    EncodingTests.this.compareContents(dest, encoding);
                }
            };
            DLTKCore.run((IWorkspaceRunnable)copy, null);
            IWorkspaceRunnable rename = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ISourceModule cu = tmpFolder.getSourceModule(fileName);
                    cu.rename("Renamed.py", true, null);
                    cu.close();
                    ISourceModule ren = tmpFolder.getSourceModule("Renamed.py");
                    IFile renFile = (IFile)ren.getUnderlyingResource();
                    EncodingTests.assertEquals((String)"Renamed file should keep encoding", (String)encoding, (String)renFile.getCharset());
                    EncodingTests.this.compareContents(ren, encoding);
                }
            };
            DLTKCore.run((IWorkspaceRunnable)rename, null);
            IWorkspaceRunnable move = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ISourceModule cu = tmpFolder.getSourceModule("Renamed.py");
                    cu.move((IModelElement)srcFolder, null, null, true, null);
                    cu.close();
                    ISourceModule moved = srcFolder.getSourceModule("Renamed.py");
                    IFile movedFile = (IFile)moved.getUnderlyingResource();
                    EncodingTests.assertEquals((String)"Renamed file should keep encoding", (String)encoding, (String)movedFile.getCharset());
                    EncodingTests.this.compareContents(moved, encoding);
                }
            };
            DLTKCore.run((IWorkspaceRunnable)move, null);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ISourceModule cu = srcFolder.getSourceModule("Renamed.py");
            if (cu.exists()) {
                cu.delete(true, null);
            }
            this.deleteFolder("/Encoding/src/tmp");
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        ISourceModule cu = srcFolder.getSourceModule("Renamed.py");
        if (cu.exists()) {
            cu.delete(true, null);
        }
        this.deleteFolder("/Encoding/src/tmp");
    }

    private IScriptFolder getScriptFolder(String string, String string2, String string3) throws ModelException {
        return this.getScriptFolder(string, string2, (IPath)new Path(string3));
    }

    public void testBug70598() throws ModelException, CoreException, IOException {
        IFile emptyFile = this.createFile("/Encoding/src/testUTF8BOM/Empty.py", new byte[0]);
        File file = new File(this.encodingProject.getLocation().toString(), emptyFile.getProjectRelativePath().toString());
        char[] fileContents = org.eclipse.dltk.compiler.util.Util.getFileCharContent((File)file, (String)"UTF-8");
        EncodingTests.assertEquals((String)"We should not get any character!", (String)"", (String)new String(fileContents));
        char[] ifileContents = Util.getResourceContentsAsCharArray((IFile)emptyFile, (String)"UTF-8");
        EncodingTests.assertEquals((String)"We should not get any character!", (String)"", (String)new String(ifileContents));
        this.deleteFile(file.getPath());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug110576() throws ModelException, CoreException {
        String os = System.getProperty("osgi.os");
        if (!"win32".equals(os)) {
            return;
        }
        IFile file = (IFile)this.encodingProject.findMember("src/testBug110576/Test.py");
        this.verifyUtf8BOM(file);
        String fileName = file.getName();
        ISourceModule testCU = this.getSourceModule(file.getFullPath().toString());
        this.createFolder("/Encoding/src/tmp");
        IScriptFolder tmpPackage = this.getScriptFolder("Encoding", "src", (IPath)new Path("tmp"));
        try {
            testCU.copy((IModelElement)tmpPackage, null, null, false, null);
            ISourceModule copiedCU = tmpPackage.getSourceModule(fileName);
            IFile copiedFile = (IFile)copiedCU.getUnderlyingResource();
            this.verifyUtf8BOM(copiedFile);
            this.compareContents(copiedCU, "UTF-8", true);
            copiedCU.rename("TestUTF8.py", false, null);
            ISourceModule renamedCU = tmpPackage.getSourceModule("TestUTF8.py");
            IFile renamedFile = (IFile)renamedCU.getUnderlyingResource();
            this.verifyUtf8BOM(renamedFile);
            fileName = renamedFile.getName();
            this.compareContents(renamedCU, "UTF-8", true);
            this.createFolder("/Encoding/src/tmp/sub");
            IScriptFolder subPackage = this.getScriptFolder("Encoding", "src", (IPath)new Path("tmp.sub"));
            renamedCU.move((IModelElement)subPackage, null, null, false, null);
            ISourceModule movedCU = subPackage.getSourceModule(fileName);
            IFile movedFile = (IFile)movedCU.getUnderlyingResource();
            this.verifyUtf8BOM(movedFile);
            this.compareContents(movedCU, "UTF-8", true);
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.deleteFolder("/Encoding/src/tmp");
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.deleteFolder("/Encoding/src/tmp");
    }

    private void verifyUtf8BOM(IFile file) throws CoreException {
        EncodingTests.assertNull((String)"File should not have any explicit charset", (Object)file.getCharset(false));
        IContentDescription contentDescription = file.getContentDescription();
        EncodingTests.assertNotNull((String)"File should have a content description", (Object)contentDescription);
        EncodingTests.assertEquals((String)"Content description charset should be UTF-8", (String)"UTF-8", (String)contentDescription.getCharset());
        EncodingTests.assertNotNull((String)"File should be UTF-8 BOM!", (Object)contentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK));
    }
}

