/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dltk.internal.ui.text.folding.FoldingMessages;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.text.folding.IFoldingPreferenceBlock;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PythonFoldingPreferenceBlock
implements IFoldingPreferenceBlock {
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            PythonFoldingPreferenceBlock.this.fOverlayStore.setValue((String)PythonFoldingPreferenceBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    public PythonFoldingPreferenceBlock(OverlayPreferenceStore store) {
        this.fOverlayStore = store;
        this.fKeys = this.createKeys();
        this.fOverlayStore.addKeys(this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList overlayKeys = new ArrayList();
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        Label label = new Label(inner, 16384);
        label.setText(FoldingMessages.DefaultFoldingPreferenceBlock_title);
        return inner;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 1;
        gd.grabExcessVerticalSpace = false;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void initializeFields() {
        Iterator it = this.fCheckBoxes.keySet().iterator();
        while (it.hasNext()) {
            Button b = (Button)it.next();
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
    }

    public void performOk() {
        this.fOverlayStore.propagate();
    }

    public void initialize() {
        this.initializeFields();
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
    }

    public void dispose() {
        this.fOverlayStore.stop();
    }
}

