/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.navigator.scriptexplorer;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerPart;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.dltk.ui.tests.core.ProjectTestSetup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class PackageExplorerShowInTests
extends TestCase {
    private static final Class clazz;
    private IScriptProject fJProject;
    private ScriptExplorerPart fPackageExplorer;
    private IWorkbenchPage fPage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ui.tests.navigator.scriptexplorer.PackageExplorerShowInTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PackageExplorerShowInTests.clazz = clazz;
    }

    public PackageExplorerShowInTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new ProjectTestSetup((Test)new TestSuite(clazz));
    }

    public static Test setUpTest(Test someTest) {
        return new ProjectTestSetup(someTest);
    }

    protected void setUp() throws Exception {
        this.fJProject = ProjectTestSetup.getProject();
        this.fPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.fPackageExplorer = (ScriptExplorerPart)this.fPage.showView("org.eclipse.dltk.ui.ScriptExplorer");
        this.fPackageExplorer.selectAndReveal((Object)new StructuredSelection());
    }

    protected void tearDown() throws Exception {
        this.fPage.hideView((IViewPart)this.fPackageExplorer);
        this.fPage = null;
        this.fPackageExplorer = null;
        this.fJProject = null;
    }

    public void testCU() throws Exception {
        IProjectFragment sourceFolder = ScriptProjectHelper.addSourceContainer(this.fJProject, "src");
        IScriptFolder pack = sourceFolder.createScriptFolder("p", true, null);
        ISourceModule cu = pack.createSourceModule("A.txt", "package p;\nclass A {\n\n}", true, null);
        IStructuredSelection selection = (IStructuredSelection)this.fPackageExplorer.convertSelection((ISelection)new StructuredSelection((Object)cu));
        PackageExplorerShowInTests.assertEquals((int)1, (int)selection.size());
        PackageExplorerShowInTests.assertEquals((Object)cu, (Object)selection.getFirstElement());
    }

    public void testCUAdaptedCU() throws Exception {
        IProjectFragment sourceFolder = ScriptProjectHelper.addSourceContainer(this.fJProject, "src");
        IScriptFolder pack = sourceFolder.createScriptFolder("p", true, null);
        final ISourceModule cu = pack.createSourceModule("A.txt", "package p;\nclass A {\n\n}", true, null);
        IAdaptable adaptable = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.dltk.core.IModelElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) {
                    return cu;
                }
                return null;
            }
        };
        IStructuredSelection selection = (IStructuredSelection)this.fPackageExplorer.convertSelection((ISelection)new StructuredSelection((Object)adaptable));
        PackageExplorerShowInTests.assertEquals((int)1, (int)selection.size());
        PackageExplorerShowInTests.assertEquals((Object)cu, (Object)selection.getFirstElement());
    }

    public void testCUAdaptedResource() throws Exception {
        IProjectFragment sourceFolder = ScriptProjectHelper.addSourceContainer(this.fJProject, "src");
        IScriptFolder pack = sourceFolder.createScriptFolder("p", true, null);
        final ISourceModule cu = pack.createSourceModule("A.txt", "package p;\nclass A {\n\n}", true, null);
        IAdaptable adaptable = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz) {
                    return cu.getResource();
                }
                return null;
            }
        };
        IStructuredSelection selection = (IStructuredSelection)this.fPackageExplorer.convertSelection((ISelection)new StructuredSelection((Object)adaptable));
        PackageExplorerShowInTests.assertEquals((int)1, (int)selection.size());
        PackageExplorerShowInTests.assertEquals((Object)cu, (Object)selection.getFirstElement());
    }
}

