/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
DisposeListener {
    private static final int BORDER = 1;
    private Shell fShell;
    private StyledText fText;
    private SourceViewer fViewer;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor = true;
    private IDLTKLanguageToolkit fToolkit;

    public SourceViewerInformationControl(Shell parent, int shellStyle, int style, IDLTKLanguageToolkit toolkit) {
        this(parent, shellStyle, style, null, toolkit);
    }

    public SourceViewerInformationControl(Shell parent, int shellStyle, int style, String statusFieldText, IDLTKLanguageToolkit toolkit) {
        int border;
        this.fToolkit = toolkit;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.initializeColors();
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (shellStyle & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        if (statusFieldText != null) {
            composite = new Composite((Composite)composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(this.fBackgroundColor);
        }
        this.createViewer(style, (Composite)composite);
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.fText.setForeground(display.getSystemColor(28));
        this.fText.setBackground(this.fBackgroundColor);
        this.initializeFont();
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    SourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        if (statusFieldText != null) {
            this.fSeparator = new Label((Composite)composite, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)composite, 131072);
            this.fStatusField.setText(statusFieldText);
            Font font = this.fStatusField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDatas);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gd2 = new GridData(1842);
            this.fStatusField.setLayoutData((Object)gd2);
            this.fStatusField.setForeground(display.getSystemColor(17));
            this.fStatusField.setBackground(this.fBackgroundColor);
        }
        this.addDisposeListener(this);
    }

    protected void createViewer(int style, Composite composite) {
        IDLTKUILanguageToolkit uiToolkit = DLTKUILanguageManager.getLanguageToolkit(this.fToolkit.getNatureId());
        this.fViewer = new ScriptSourceViewer(composite, null, null, false, style, uiToolkit.getPreferenceStore());
        this.fViewer.configure((SourceViewerConfiguration)uiToolkit.createSourceViewerConfiguration());
    }

    private void initializeColors() {
        RGB bgRGB = this.getHoverBackgroundColorRGB();
        if (bgRGB != null) {
            this.fBackgroundColor = new Color((Device)this.fShell.getDisplay(), bgRGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.fShell.getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    private RGB getHoverBackgroundColorRGB() {
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("sourceHoverBackgroundColor.SystemDefault") ? null : PreferenceConverter.getColor((IPreferenceStore)store, (String)"sourceHoverBackgroundColor");
    }

    public SourceViewerInformationControl(Shell parent, int style, IDLTKLanguageToolkit toolkit) {
        this(parent, 12, style, toolkit);
    }

    public SourceViewerInformationControl(Shell parent, int style, String statusFieldText, IDLTKLanguageToolkit toolkit) {
        this(parent, 12, style, statusFieldText, toolkit);
    }

    public SourceViewerInformationControl(Shell parent, IDLTKLanguageToolkit toolkit) {
        this(parent, 0, toolkit);
    }

    public SourceViewerInformationControl(Shell parent, String statusFieldText, IDLTKLanguageToolkit toolkit) {
        this(parent, 0, statusFieldText, toolkit);
    }

    private void initializeFont() {
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        StyledText styledText = this.getViewer().getTextWidget();
        styledText.setFont(font);
    }

    public void setInput(Object input) {
        if (input instanceof String) {
            this.setInformation((String)input);
        } else {
            this.setInformation(null);
        }
    }

    public void setInformation(String content) {
        if (content == null) {
            this.fViewer.setInput(null);
            return;
        }
        Document doc = new Document(content);
        IDLTKUILanguageToolkit uiToolkit = DLTKUILanguageManager.getLanguageToolkit(this.fToolkit.getNatureId());
        ScriptTextTools textTools = uiToolkit.getTextTools();
        if (textTools != null) {
            textTools.setupDocumentPartitioner((IDocument)doc, uiToolkit.getPartitioningId());
        }
        this.fViewer.setInput((Object)doc);
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fStatusTextFont = null;
        this.fShell = null;
        this.fText = null;
    }

    public final void dispose() {
        if (!this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void setSize(int width, int height) {
        if (this.fStatusField != null) {
            GridData gd = (GridData)this.fViewer.getTextWidget().getLayoutData();
            Point statusSize = this.fStatusField.computeSize(-1, -1, true);
            Point separatorSize = this.fSeparator.computeSize(-1, -1, true);
            gd.heightHint = height - statusSize.y - separatorSize.y;
        }
        this.fShell.setSize(width, height);
        if (this.fStatusField != null) {
            this.fShell.pack(true);
        }
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this.fShell.computeSize(x, y);
        if (size.x > this.fMaxWidth) {
            x = this.fMaxWidth;
        }
        if (size.y > this.fMaxHeight) {
            y = this.fMaxHeight;
        }
        if (x != -1 || y != -1) {
            size = this.fShell.computeSize(x, y, false);
        }
        return size;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }
}

