/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import java.util.Arrays;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TodoTagRule
implements IPredicateRule {
    private final IToken token;
    private final char[][] todoTags;
    private final boolean caseSensitive;
    private final boolean[] candidates;
    private final int maxLength;

    public TodoTagRule(IToken t, String[] tags, boolean caseSensitive) {
        this.token = t;
        this.todoTags = new char[tags.length][];
        int maxLen = 0;
        int i = 0;
        while (i < this.todoTags.length) {
            char[] tag = tags[i].toCharArray();
            if (!caseSensitive) {
                int j = 0;
                while (j < tag.length) {
                    tag[j] = Character.toUpperCase(tag[j]);
                    ++j;
                }
            }
            this.todoTags[i] = tag;
            maxLen = Math.max(tag.length, maxLen);
            ++i;
        }
        this.candidates = new boolean[this.todoTags.length];
        this.caseSensitive = caseSensitive;
        this.maxLength = maxLen;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int i;
        int c;
        Arrays.fill(this.candidates, true);
        int candidateCount = this.todoTags.length;
        int count = 0;
        while ((c = scanner.read()) != -1) {
            i = 0;
            while (i < this.todoTags.length) {
                if (this.candidates[i]) {
                    char[] tag = this.todoTags[i];
                    if (count < tag.length) {
                        boolean eq;
                        boolean bl = this.caseSensitive ? c == tag[count] : (eq = Character.toUpperCase((char)c) == tag[count]);
                        if (!eq) {
                            this.candidates[i] = false;
                            if (--candidateCount == 0) {
                                this.unreadScanner(scanner, count + 1);
                                return Token.UNDEFINED;
                            }
                        }
                    } else if (count == tag.length && !Character.isJavaIdentifierPart((char)c)) {
                        scanner.unread();
                        return this.getSuccessToken();
                    }
                }
                ++i;
            }
            if (++count != this.maxLength) continue;
            c = scanner.read();
            if (c != -1 && !Character.isJavaIdentifierPart((char)c)) {
                c = -1;
            }
            scanner.unread();
            break;
        }
        if (c == -1) {
            i = 0;
            while (i < this.todoTags.length) {
                if (this.candidates[i] && count == this.todoTags[i].length) {
                    return this.getSuccessToken();
                }
                ++i;
            }
        }
        this.unreadScanner(scanner, count);
        return Token.UNDEFINED;
    }

    private void unreadScanner(ICharacterScanner scanner, int num) {
        int i = 0;
        while (i < num) {
            scanner.unread();
            ++i;
        }
    }
}

