/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.internal.testing.launcher.ITestFinder;
import org.eclipse.dltk.internal.testing.launcher.ITestKind;
import org.eclipse.dltk.testing.DLTKTestingPlugin;

public class TestKind
implements ITestKind {
    private final IConfigurationElement fElement;
    private ITestFinder fFinder;

    public TestKind(IConfigurationElement element) {
        this.fElement = element;
        this.fFinder = null;
    }

    public ITestFinder getFinder() {
        if (this.fFinder == null) {
            try {
                this.fFinder = (ITestFinder)this.fElement.createExecutableExtension("finderClass");
            }
            catch (CoreException e1) {
                DLTKTestingPlugin.log(e1);
                this.fFinder = ITestFinder.NULL;
            }
        }
        return this.fFinder;
    }

    public String getDisplayName() {
        return this.getAttribute("displayName");
    }

    public String getFinderClassName() {
        return this.getAttribute("finderClass");
    }

    public String getId() {
        return this.getAttribute("id");
    }

    public String getLoaderClassName() {
        return this.getAttribute("loaderClass");
    }

    public String getLoaderPluginId() {
        return this.getAttribute("loaderPluginId");
    }

    public String getPrecededKindId() {
        String attribute = this.getAttribute("precedesTestKind");
        return attribute == null ? "" : attribute;
    }

    public boolean isNull() {
        return false;
    }

    protected String getAttribute(String attributeName) {
        return this.fElement.getAttribute(attributeName);
    }

    boolean precedes(ITestKind otherKind) {
        String precededKindId = this.getPrecededKindId();
        String[] ids = precededKindId.split(",");
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(otherKind.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getDisplayName()) + " (id: " + this.getId() + ")";
    }
}

