/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.indexing.IndexRequest;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.util.Util;

class AddFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;

    public AddFolderToIndex(IPath folderPath, IProject project, char[][] inclusionPatterns, char[][] exclusionPatterns, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.project = project;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource folder = this.project.getParent().findMember(this.folderPath);
        if (folder == null) return true;
        if (folder.getType() == 1) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                final IPath container = this.containerPath;
                final IndexManager indexManager = this.manager;
                final IScriptProject project = DLTKCore.create(this.project);
                final IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(project);
                final ISourceElementParser parser = indexManager.getSourceElementParser(project);
                final SourceIndexerRequestor requestor = indexManager.getSourceRequestor(project);
                if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                    folder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            if (proxy.getType() == 1) {
                                IFile file = (IFile)proxy.requestResource();
                                if (Util.isValidSourceModule((IModelElement)project, (IResource)file)) {
                                    indexManager.addSource(file, container, parser, requestor, toolkit);
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                } else {
                    folder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            switch (proxy.getType()) {
                                case 1: {
                                    IResource resource = proxy.requestResource();
                                    if (Util.isValidSourceModule((IModelElement)project, resource) && !Util.isExcluded(resource, AddFolderToIndex.this.inclusionPatterns, AddFolderToIndex.this.exclusionPatterns)) {
                                        indexManager.addSource((IFile)resource, container, parser, requestor, toolkit);
                                    }
                                    return false;
                                }
                                case 2: {
                                    if (AddFolderToIndex.this.exclusionPatterns == null || AddFolderToIndex.this.inclusionPatterns != null || !Util.isExcluded(proxy.requestFullPath(), AddFolderToIndex.this.inclusionPatterns, AddFolderToIndex.this.exclusionPatterns, true)) break;
                                    return false;
                                }
                            }
                            return true;
                        }
                    }, 0);
                }
            }
            catch (CoreException coreException) {
                Object var11_11 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var11_13 = null;
            monitor.exitRead();
            return true;
        }
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.containerPath;
    }
}

