/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.search;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResult;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.internal.dltk.DLTKStructureBridge;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;
import org.eclipse.mylyn.internal.dltk.search.DLTKActiveSearchResultUpdater;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;

public abstract class AbstractDLTKRelationProvider
extends AbstractRelationProvider {
    public static final String ID_GENERIC = "org.eclipse.dltk.mylyn.relation";
    public static final String NAME = "DLTK relationships";
    private static final int DEFAULT_DEGREE = 2;
    private static final List runningJobs = new ArrayList();
    private DLTKStructureBridge fBridge;

    public String getGenericId() {
        return ID_GENERIC;
    }

    protected AbstractDLTKRelationProvider(String structureKind, String id, DLTKStructureBridge bridge) {
        super(structureKind, id);
        this.fBridge = bridge;
    }

    protected void findRelated(IInteractionElement node, int degreeOfSeparation) {
        if (node == null) {
            return;
        }
        if (node.getContentType() == null) {
            MylynStatusHandler.log("null content type for: " + node, this);
            return;
        }
        if (!node.getContentType().equals(this.fBridge.contentType)) {
            return;
        }
        IModelElement modelElement = DLTKCore.create((String)node.getHandleIdentifier());
        if (!this.acceptElement(modelElement) || !modelElement.exists()) {
            return;
        }
        IDLTKSearchScope scope = this.createSearchScope(modelElement, degreeOfSeparation);
        if (scope != null) {
            this.runJob(node, degreeOfSeparation, this.getId());
        }
    }

    private IDLTKSearchScope createSearchScope(IModelElement element, int degreeOfSeparation) {
        IInteractionElement interesting;
        AbstractContextStructureBridge bridge;
        Iterator it;
        Set landmarks = ContextCorePlugin.getContextManager().getActiveLandmarks();
        List interestingElements = ContextCorePlugin.getContextManager().getActiveContext().getInteresting();
        HashSet<Object> searchElements = new HashSet<Object>();
        int includeMask = 1;
        if (degreeOfSeparation == 1) {
            it = landmarks.iterator();
            while (it.hasNext()) {
                IModelElement landmarkElement;
                Object o;
                IInteractionElement landmark = (IInteractionElement)it.next();
                if (!this.includeNodeInScope(landmark, bridge = ContextCorePlugin.getDefault().getStructureBridge(landmark.getContentType())) || !((o = bridge.getObjectForHandle(landmark.getHandleIdentifier())) instanceof IModelElement) || !(landmarkElement = (IModelElement)o).exists()) continue;
                if (landmarkElement instanceof IMember && !landmark.getInterest().isPropagated()) {
                    searchElements.add(((IMember)landmarkElement).getSourceModule());
                    continue;
                }
                if (!(landmarkElement instanceof ISourceModule)) continue;
                searchElements.add(landmarkElement);
            }
        } else if (degreeOfSeparation == 2) {
            it = interestingElements.iterator();
            while (it.hasNext()) {
                IModelElement interestingElement;
                Object object;
                interesting = (IInteractionElement)it.next();
                if (!this.includeNodeInScope(interesting, bridge = ContextCorePlugin.getDefault().getStructureBridge(interesting.getContentType())) || !((object = bridge.getObjectForHandle(interesting.getHandleIdentifier())) instanceof IModelElement) || !(interestingElement = (IModelElement)object).exists()) continue;
                if (interestingElement instanceof IMember && !interesting.getInterest().isPropagated()) {
                    searchElements.add(((IMember)interestingElement).getSourceModule());
                    continue;
                }
                if (!(interestingElement instanceof ISourceModule)) continue;
                searchElements.add(interestingElement);
            }
        } else if (degreeOfSeparation == 3 || degreeOfSeparation == 4) {
            it = interestingElements.iterator();
            while (it.hasNext()) {
                IScriptProject scriptProject;
                IProject project;
                IResource resource;
                interesting = (IInteractionElement)it.next();
                if (!this.includeNodeInScope(interesting, bridge = ContextCorePlugin.getDefault().getStructureBridge(interesting.getContentType())) || (resource = ResourcesUiBridgePlugin.getDefault().getResourceForElement(interesting, true)) == null || (project = resource.getProject()) == null || !project.exists() || (scriptProject = DLTKCore.create((IProject)project)) == null || !scriptProject.exists()) continue;
                searchElements.add(scriptProject);
            }
            if (degreeOfSeparation == 4) {
                includeMask = 7;
            }
        } else if (degreeOfSeparation == 5) {
            return SearchEngine.createWorkspaceScope(null);
        }
        if (searchElements.size() == 0) {
            return null;
        }
        IModelElement[] elements = new IModelElement[searchElements.size()];
        int j = 0;
        Iterator it2 = searchElements.iterator();
        while (it2.hasNext()) {
            IModelElement searchElement;
            elements[j] = searchElement = (IModelElement)it2.next();
            ++j;
        }
        return SearchEngine.createSearchScope((IModelElement[])elements, (int)includeMask, null);
    }

    private boolean includeNodeInScope(IInteractionElement interesting, AbstractContextStructureBridge bridge2) {
        if (interesting == null || bridge2 == null) {
            return false;
        }
        if (interesting.getContentType() == null) {
            MylynStatusHandler.log("null content type for: " + interesting.getHandleIdentifier(), this);
            return false;
        }
        return interesting.getContentType().equals(this.fBridge.contentType) || bridge2.isDocument(interesting.getHandleIdentifier());
    }

    protected boolean acceptResultElement(IModelElement element) {
        return true;
    }

    protected boolean acceptElement(IModelElement modelElement) {
        return modelElement != null && (modelElement instanceof IMember || modelElement instanceof IType);
    }

    private void runJob(final IInteractionElement node, final int degreeOfSeparation, String kind) {
        int limitTo = 0;
        if (kind.equals("org.eclipse.dltk.mylyn.relation.references")) {
            limitTo = 1;
        } else if (!kind.equals("org.eclipse.dltk.mylyn.relation.implementors")) {
            if (kind.equals("org.eclipse.dltk.mylyn.relation.junitreferences")) {
                limitTo = 1;
            } else if (kind.equals("org.eclipse.dltk.mylyn.relation.readaccess")) {
                limitTo = 1;
            } else if (kind.equals("org.eclipse.dltk.mylyn.relation.writeaccess")) {
                limitTo = 1;
            }
        }
        DLTKSearchOperation query = (DLTKSearchOperation)this.getSearchOperation(node, limitTo, degreeOfSeparation);
        if (query == null) {
            return;
        }
        DLTKSearchJob job = new DLTKSearchJob(query.getLabel(), query);
        query.addListener(new IActiveSearchListener(){
            private boolean gathered = false;

            public boolean resultsGathered() {
                return this.gathered;
            }

            public void searchCompleted(List l) {
                if (l == null) {
                    return;
                }
                ArrayList<IModelElement> relatedHandles = new ArrayList<IModelElement>();
                Object[] elements = l.toArray();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof IModelElement) {
                        relatedHandles.add((IModelElement)elements[i]);
                    }
                    ++i;
                }
                ListIterator it = relatedHandles.listIterator();
                while (it.hasNext()) {
                    IModelElement element = (IModelElement)it.next();
                    if (!AbstractDLTKRelationProvider.this.acceptResultElement(element)) continue;
                    AbstractDLTKRelationProvider.this.incrementInterest(node, ((AbstractDLTKRelationProvider)AbstractDLTKRelationProvider.this).fBridge.contentType, element.getHandleIdentifier(), degreeOfSeparation);
                }
                this.gathered = true;
                AbstractDLTKRelationProvider.this.searchCompleted(node);
            }
        });
        InternalSearchUI.getInstance();
        runningJobs.add(job);
        job.setPriority(40);
        job.schedule();
    }

    public IActiveSearchOperation getSearchOperation(IInteractionElement node, int limitTo, int degreeOfSeparation) {
        IModelElement modelElement = DLTKCore.create((String)node.getHandleIdentifier());
        if (modelElement == null || !modelElement.exists()) {
            return null;
        }
        IDLTKSearchScope scope = this.createSearchScope(modelElement, degreeOfSeparation);
        if (scope == null) {
            return null;
        }
        ElementQuerySpecification specs = new ElementQuerySpecification(modelElement, limitTo, scope, "Mylyn degree of separation: " + degreeOfSeparation);
        return new DLTKSearchOperation((QuerySpecification)specs);
    }

    public void stopAllRunningJobs() {
        ListIterator it = runningJobs.listIterator();
        while (it.hasNext()) {
            Job j = (Job)it.next();
            j.cancel();
        }
        runningJobs.clear();
    }

    protected int getDefaultDegreeOfSeparation() {
        return 2;
    }

    protected static class DLTKSearchJob
    extends Job {
        private DLTKSearchOperation op;

        public DLTKSearchJob(String name, DLTKSearchOperation op) {
            super(name);
            this.op = op;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return this.op.run(monitor);
        }
    }

    protected static class DLTKSearchOperation
    extends DLTKSearchQuery
    implements IActiveSearchOperation {
        private ISearchResult result = null;
        private List listeners = new ArrayList();

        public ISearchResult getSearchResult() {
            if (this.result == null) {
                this.result = new DLTKSearchResult((DLTKSearchQuery)this);
            }
            new DLTKActiveSearchResultUpdater((DLTKSearchResult)this.result);
            return this.result;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IStatus runStatus = super.run(monitor);
                ISearchResult result = this.getSearchResult();
                if (result instanceof DLTKSearchResult) {
                    Object[] objs = ((DLTKSearchResult)result).getElements();
                    if (objs == null) {
                        this.notifySearchCompleted(null);
                    } else {
                        ArrayList<Object> l = new ArrayList<Object>();
                        int i = 0;
                        while (i < objs.length) {
                            l.add(objs[i]);
                            ++i;
                        }
                        this.notifySearchCompleted(l);
                    }
                }
                return runStatus;
            }
            catch (ConcurrentModificationException cme) {
                MylynStatusHandler.log(cme, "script search failed");
            }
            catch (Throwable t) {
                MylynStatusHandler.log(t, "script search failed");
            }
            Status status = new Status(2, "org.eclipse.dltk.mylyn", 0, "could not run Script search", null);
            this.notifySearchCompleted(null);
            return status;
        }

        public DLTKSearchOperation(QuerySpecification data) {
            super(data);
        }

        public void addListener(IActiveSearchListener l) {
            this.listeners.add(l);
        }

        public void removeListener(IActiveSearchListener l) {
            this.listeners.remove(l);
        }

        public void notifySearchCompleted(List l) {
            ListIterator it = this.listeners.listIterator();
            while (it.hasNext()) {
                IActiveSearchListener listener = (IActiveSearchListener)it.next();
                listener.searchCompleted(l);
            }
        }
    }
}

