/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk;

import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.dltk.MylynStatusHandler;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class InterestUpdateDeltaListener
implements IElementChangedListener {
    private static boolean asyncExecMode = true;

    public void elementChanged(ElementChangedEvent event) {
        IModelElementDelta delta = event.getDelta();
        this.handleDelta(delta.getAffectedChildren());
    }

    private void handleDelta(IModelElementDelta[] delta) {
        try {
            IInteractionElement element;
            IModelElement added = null;
            IModelElement removed = null;
            int i = 0;
            while (i < delta.length) {
                IModelElementDelta child = delta[i];
                if (child.getKind() == 1) {
                    if (added == null) {
                        added = child.getElement();
                    }
                } else if (child.getKind() == 2 && removed == null) {
                    removed = child.getElement();
                }
                this.handleDelta(child.getAffectedChildren());
                ++i;
            }
            if (added != null && removed != null) {
                IInteractionElement element2 = ContextCorePlugin.getContextManager().getElement(removed.getHandleIdentifier());
                if (element2 != null) {
                    this.resetHandle(element2, added.getHandleIdentifier());
                }
            } else if (removed != null && (element = ContextCorePlugin.getContextManager().getElement(removed.getHandleIdentifier())) != null) {
                this.delete(element);
            }
        }
        catch (Throwable t) {
            MylynStatusHandler.fail(t, "delta update failed", false);
        }
    }

    private void resetHandle(final IInteractionElement element, final String newHandle) {
        if (!asyncExecMode) {
            ContextCorePlugin.getContextManager().updateHandle(element, newHandle);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ContextCorePlugin.getContextManager().updateHandle(element, newHandle);
                    }
                });
            }
        }
    }

    private void delete(final IInteractionElement element) {
        if (!asyncExecMode) {
            ContextCorePlugin.getContextManager().deleteElement(element);
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ContextCorePlugin.getContextManager().deleteElement(element);
                    }
                });
            }
        }
    }

    public static void setAsyncExecMode(boolean asyncExecMode) {
        InterestUpdateDeltaListener.asyncExecMode = asyncExecMode;
    }
}

