/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.rse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.rse.services.shells.HostShellOutputStream;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;

public class MyHostShellProcessAdapter
extends Process
implements IHostShellOutputListener {
    private IHostShell hostShell;
    private PipedInputStream inputStream = null;
    private PipedInputStream errorStream = null;
    private HostShellOutputStream outputStream = null;
    private PipedOutputStream hostShellInput = null;
    private PipedOutputStream hostShellError = null;
    private String pattern1;
    private int prefixCounter = 0;

    public MyHostShellProcessAdapter(IHostShell hostShell, String pattern1) throws IOException {
        this.hostShell = hostShell;
        this.pattern1 = pattern1;
        this.hostShellInput = new PipedOutputStream();
        this.hostShellError = new PipedOutputStream();
        this.inputStream = new PipedInputStream(this.hostShellInput);
        this.errorStream = new PipedInputStream(this.hostShellError);
        this.outputStream = new HostShellOutputStream(hostShell);
        this.hostShell.getStandardOutputReader().addOutputListener((IHostShellOutputListener)this);
        this.hostShell.getStandardErrorReader().addOutputListener((IHostShellOutputListener)this);
    }

    public synchronized void destroy() {
        this.hostShell.exit();
        this.notifyAll();
        try {
            this.hostShellInput.close();
            this.hostShellError.close();
            this.inputStream.close();
            this.errorStream.close();
            this.outputStream.close();
        }
        catch (IOException iOException) {}
    }

    public synchronized int exitValue() {
        if (this.hostShell.isActive()) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (this.hostShell.isActive()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.wait(1000L);
            if (this.inputStream.available() != 0 || this.errorStream.available() != 0) {
                throw new InterruptedException();
            }
            this.hostShellInput.close();
            this.hostShellError.close();
            this.inputStream.close();
            this.errorStream.close();
            this.outputStream.close();
        }
        catch (IOException iOException) {}
        return 0;
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        IHostOutput[] input = event.getLines();
        PipedOutputStream outputStream = event.isError() ? this.hostShellError : this.hostShellInput;
        try {
            int i = 0;
            while (i < input.length) {
                String line = input[i].getString();
                if (line != null) {
                    String trimLine;
                    if (!event.isError() && (trimLine = line.trim()).endsWith(this.pattern1)) {
                        if (this.prefixCounter == 1 && !trimLine.equals(this.pattern1)) {
                            int pos = line.indexOf(this.pattern1);
                            outputStream.write(line.substring(0, pos).getBytes());
                            ((OutputStream)outputStream).write(10);
                            ((OutputStream)outputStream).flush();
                        }
                        ++this.prefixCounter;
                        if (this.prefixCounter == 2) {
                            this.hostShellError.close();
                            this.hostShellInput.close();
                            return;
                        }
                    } else if (this.prefixCounter == 1) {
                        outputStream.write(line.getBytes());
                        ((OutputStream)outputStream).write(10);
                        ((OutputStream)outputStream).flush();
                    }
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
    }
}

