/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.tcl.internal.ui.text.TclTextTools;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;
import org.eclipse.dltk.ui.editor.highlighting.HighlightedPosition;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;

public class DefaultTclSemanticHighlightingExtension
implements ISemanticHighlightingExtension {
    private SemanticHighlighting[] highlightings = new SemanticHighlighting[]{new TclTextTools.SH("DLTK_function_definition", null, PreferencesMessages.DLTKEditorPreferencePage_function_colors), new TclTextTools.SH("DLTK_argument", null, PreferencesMessages.DLTKEditorPreferencePage_arguments), new TclTextTools.SH("DLTK_class_definition", null, PreferencesMessages.DLTKEditorPreferencePage_class_colors), new TclTextTools.SH("DLTK_base_class", null, PreferencesMessages.DLTKEditorPreferencePage_base_classes)};
    private static final int HL_PROCEDURES = 0;
    private static final int HL_ARGUMENTS = 1;
    private static final int HL_CLASSES = 2;
    private static final int HL_BASE_CLASSES = 3;

    public HighlightedPosition[] calculatePositions(ASTNode node, ISemanticHighlightingRequestor requestor) {
        MethodDeclaration m;
        if (node instanceof MethodDeclaration) {
            m = (MethodDeclaration)node;
            requestor.addPosition(m.getNameStart(), m.getNameEnd(), 0);
        }
        if (node instanceof Argument) {
            m = (Argument)node;
            requestor.addPosition(m.getNameStart(), m.getNameEnd(), 1);
        }
        if (node instanceof TypeDeclaration) {
            TypeDeclaration t = (TypeDeclaration)node;
            ASTListNode s = t.getSuperClasses();
            if (s != null && s.getChilds() != null) {
                List children = s.getChilds();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    ASTNode n = (ASTNode)it.next();
                    requestor.addPosition(n.sourceStart(), n.sourceEnd(), 3);
                }
            }
            requestor.addPosition(t.getNameStart(), t.getNameEnd(), 2);
        }
        return null;
    }

    public void processNode(ASTNode node, ISemanticHighlightingRequestor requestor) {
        this.calculatePositions(node, requestor);
    }

    public SemanticHighlighting[] getHighlightings() {
        return this.highlightings;
    }
}

