/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.tests.navigator.scriptexplorer;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.tests.DLTKUITestsPlugin;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.dltk.ui.tests.navigator.scriptexplorer.MockPluginView;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ContentProviderTests2
extends TestCase {
    private IProjectFragment fRoot1;
    private IScriptFolder fPack1;
    private IScriptFolder fPack2;
    private IScriptFolder fPack4;
    private IScriptFolder fPack3;
    private IWorkspace fWorkspace;
    private IWorkbench fWorkbench;
    private MockPluginView fMyPart;
    private ITreeContentProvider fProvider;
    private IScriptFolder fPack5;
    private IScriptProject fJProject3;
    private IScriptFolder fPack6;
    private IProjectFragment fInternalRoot1;
    private IScriptFolder fA;
    private IScriptFolder fX;
    private IScriptFolder fB;
    private IScriptFolder fC;
    private IScriptFolder fY;
    private IFile fFile1;
    private IFile fFile2;
    private ISourceModule fCU1;
    private ISourceModule fCU2;
    private IWorkbenchPage page;
    private boolean fEnableAutoBuildAfterTesting;

    public ContentProviderTests2(String name) {
        super(name);
    }

    public void testGetChildrenProject() throws Exception {
        Object[] expectedChildren = new Object[]{this.fPack1, this.fPack2, this.fPack3, this.fInternalRoot1, this.fFile1, this.fFile2};
        Object[] children = this.fProvider.getChildren((Object)this.fJProject3);
        ContentProviderTests2.assertTrue((String)"Wrong children found for project", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrentMidLevelFragment() throws Exception {
        Object[] expectedChildren = new Object[]{this.fPack4, this.fPack5};
        Object[] children = this.fProvider.getChildren((Object)this.fPack3);
        ContentProviderTests2.assertTrue((String)"Wrong children found for ScriptFolder", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragment() throws Exception {
        Object[] expectedChildren = new Object[]{};
        Object[] children = this.fProvider.getChildren((Object)this.fPack1);
        ContentProviderTests2.assertTrue((String)"Wrong children found for ScriptFolder", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragmentWithCU() throws Exception {
        Object[] expectedChildren = new Object[]{this.fCU1.getResource()};
        Object[] children = this.fProvider.getChildren((Object)this.fPack2);
        ContentProviderTests2.assertTrue((String)"Wrong children found for ScriptFolder with CU", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragmentFile() throws Exception {
        Object[] expectedChildren = new Object[]{};
        Object[] children = this.fProvider.getChildren((Object)this.fPack1);
        ContentProviderTests2.assertTrue((String)"Wrong children found for ScriptFolder with File", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenBottomLevelFragment2() throws Exception {
        Object[] expectedChildren = new Object[]{this.fCU2.getResource()};
        Object[] children = this.fProvider.getChildren((Object)this.fPack6);
        ContentProviderTests2.assertTrue((String)"Wrong children found for ScriptFolder", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetChildrenMidLevelFragmentInInternalArchive() throws Exception {
        Object[] expectedChildren = new Object[]{this.fC};
        Object[] children = this.fProvider.getChildren((Object)this.fB);
        ContentProviderTests2.assertTrue((String)"wrong children found for a NON bottom ScriptFolder in ProjectFragment Internal Archive", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void getChildrenInternalArchive() throws Exception {
        Object[] expectedChildren = new Object[]{this.fX, this.fA, this.fInternalRoot1.getScriptFolder("")};
        Object[] children = this.fProvider.getChildren((Object)this.fInternalRoot1);
        ContentProviderTests2.assertTrue((String)"Wrong child found for ProjectFragment Internal Archive", (boolean)this.compareArrays(children, expectedChildren));
    }

    public void testGetParentArchive() throws Exception {
        this.fProvider.getParent((Object)this.fInternalRoot1);
    }

    public void testGetParentMidLevelFragmentInArchive() throws Exception {
        IScriptFolder expectedParent = this.fB;
        Object parent = this.fProvider.getParent((Object)this.fC);
        ContentProviderTests2.assertTrue((String)"Wrong parent found for a NON top level ScriptFolder in an Archive", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentTopLevelFragmentInArchive() throws Exception {
        IProjectFragment expectedParent = this.fInternalRoot1;
        Object parent = this.fProvider.getParent((Object)this.fA);
        ContentProviderTests2.assertTrue((String)"Wrong parent found for a top level ScriptFolder in an Archive", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentTopLevelFragment() throws Exception {
        IScriptProject expectedParent = this.fJProject3;
        Object parent = this.fProvider.getParent((Object)this.fPack3);
        ContentProviderTests2.assertTrue((String)"Wrong parent found for a top level ScriptFolder", (boolean)expectedParent.equals(parent));
    }

    public void testGetParentMidLevelFragment() throws Exception {
        IScriptFolder expectedParent = this.fPack3;
        Object parent = this.fProvider.getParent((Object)this.fPack5);
        ContentProviderTests2.assertTrue((String)"Wrong parent found for a NON top level ScriptFolder", (boolean)expectedParent.equals(parent));
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fWorkspace = ResourcesPlugin.getWorkspace();
        ContentProviderTests2.assertNotNull((Object)this.fWorkspace);
        IWorkspaceDescription workspaceDesc = this.fWorkspace.getDescription();
        this.fEnableAutoBuildAfterTesting = workspaceDesc.isAutoBuilding();
        if (this.fEnableAutoBuildAfterTesting) {
            ScriptProjectHelper.setAutoBuilding(false);
        }
        this.fJProject3 = ScriptProjectHelper.createScriptProject("TestProject3");
        ContentProviderTests2.assertNotNull((String)"project3 null", (Object)this.fJProject3);
        Object[] resource = this.fJProject3.getForeignResources();
        int i = 0;
        while (i < resource.length) {
            Object object = resource[i];
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                if (".buildpath".equals(file.getName())) {
                    this.fFile1 = file;
                } else if (".project".equals(file.getName())) {
                    this.fFile2 = file;
                }
            }
            ++i;
        }
        ContentProviderTests2.assertNotNull((Object)this.fFile1);
        ContentProviderTests2.assertNotNull((Object)this.fFile2);
        this.fRoot1 = ScriptProjectHelper.addSourceContainer(this.fJProject3, "");
        ContentProviderTests2.assertNotNull((String)"getting default package", (Object)this.fRoot1);
        File myInternalLibArchive = DLTKUITestsPlugin.getDefault().getFileInPlugin((IPath)new Path("testresources/myinternallib.zip"));
        ContentProviderTests2.assertTrue((String)"lib not found", (myInternalLibArchive != null && myInternalLibArchive.exists() ? 1 : 0) != 0);
        this.fInternalRoot1 = ScriptProjectHelper.addLibraryWithImport(this.fJProject3, Path.fromOSString((String)myInternalLibArchive.getPath()));
        this.fA = this.fInternalRoot1.getScriptFolder("a");
        this.fX = this.fInternalRoot1.getScriptFolder("x");
        this.fB = this.fInternalRoot1.getScriptFolder("a/b");
        this.fC = this.fInternalRoot1.getScriptFolder("a/b/c");
        this.fInternalRoot1.getScriptFolder("a/d");
        this.fY = this.fInternalRoot1.getScriptFolder("x/y");
        this.fPack1 = this.fRoot1.createScriptFolder("pack1", true, null);
        this.fPack2 = this.fRoot1.createScriptFolder("pack2", true, null);
        this.fPack3 = this.fRoot1.createScriptFolder("pack3", true, null);
        this.fPack4 = this.fRoot1.createScriptFolder("pack3/pack4", true, null);
        this.fPack5 = this.fRoot1.createScriptFolder("pack3/pack5", true, null);
        this.fPack6 = this.fRoot1.createScriptFolder("pack3/pack5/pack6", true, null);
        this.fCU1 = this.fPack2.createSourceModule("Object.java", "", true, null);
        this.fCU2 = this.fPack6.createSourceModule("Object.java", "", true, null);
        this.setUpMockView();
    }

    public void setUpMockView() throws Exception {
        this.fWorkbench = PlatformUI.getWorkbench();
        ContentProviderTests2.assertNotNull((Object)this.fWorkbench);
        this.page = this.fWorkbench.getActiveWorkbenchWindow().getActivePage();
        ContentProviderTests2.assertNotNull((Object)this.page);
        MockPluginView myPart = new MockPluginView();
        ContentProviderTests2.assertNotNull((Object)((Object)myPart));
        myPart = this.page.showView("org.eclipse.dltk.ui.tests.packageview.MockPluginView");
        if (myPart instanceof MockPluginView) {
            this.fMyPart = myPart;
            this.fMyPart.setFolding(false);
            this.fMyPart.fRefreshedObjects.clear();
            this.fProvider = (ITreeContentProvider)this.fMyPart.getTreeViewer().getContentProvider();
        } else {
            ContentProviderTests2.assertTrue((String)"Unable to get view", (boolean)false);
        }
        ContentProviderTests2.assertNotNull((Object)this.fProvider);
    }

    protected void tearDown() throws Exception {
        this.fInternalRoot1.close();
        ScriptProjectHelper.delete((IModelElement)this.fJProject3);
        this.page.hideView((IViewPart)this.fMyPart);
        if (this.fEnableAutoBuildAfterTesting) {
            ScriptProjectHelper.setAutoBuilding(true);
        }
        super.tearDown();
    }

    private boolean compareArrays(Object[] children, Object[] expectedChildren) {
        if (children.length != expectedChildren.length) {
            return false;
        }
        int i = 0;
        while (i < children.length) {
            IResource res;
            IModelElement el;
            Object child = children[i];
            if (child instanceof IModelElement ? !this.contains(el = (IModelElement)child, expectedChildren) : child instanceof IResource && !this.contains(res = (IResource)child, expectedChildren)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean contains(IResource res, Object[] expectedChildren) {
        int i = 0;
        while (i < expectedChildren.length) {
            IResource expres;
            Object object = expectedChildren[i];
            if (object instanceof IResource && (expres = (IResource)object).equals((Object)res)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(IModelElement fragment, Object[] expectedChildren) {
        int i = 0;
        while (i < expectedChildren.length) {
            IModelElement expfrag;
            Object object = expectedChildren[i];
            if (object instanceof IModelElement && (expfrag = (IModelElement)object).equals(fragment)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

