/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.launching;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.tests.launching.IFileVisitor;
import org.eclipse.osgi.util.NLS;

public class PathFilesContainer {
    private static final String PATH = "path";
    private IEnvironment environment;

    public PathFilesContainer(IEnvironment environment) {
        this.environment = environment;
    }

    public void accept(IFileVisitor visitor) {
        this.accept(visitor, (IProgressMonitor)new NullProgressMonitor());
    }

    public void accept(IFileVisitor visitor, IProgressMonitor monitor) {
        this.accept(visitor, -1, monitor);
    }

    public void accept(IFileVisitor visitor, int deep, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Map env = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        String path = null;
        Iterator it = env.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (name.compareToIgnoreCase(PATH) != 0) continue;
            path = (String)env.get(name);
        }
        if (path == null) {
            return;
        }
        String separator = Platform.getOS().equals("win32") ? ";" : ":";
        ArrayList<IPath> folders = new ArrayList<IPath>();
        String[] res = path.split(separator);
        int i = 0;
        while (i < res.length) {
            folders.add(Path.fromOSString((String)res[i]));
            ++i;
        }
        ArrayList searchedFiles = new ArrayList();
        Iterator iter = folders.iterator();
        while (iter.hasNext()) {
            IFileHandle f;
            IPath folder = (IPath)iter.next();
            if (folder == null || !(f = this.environment.getFile(folder)).isDirectory()) continue;
            this.visitFolder(visitor, f, monitor, deep, searchedFiles);
        }
    }

    protected void visitFolder(IFileVisitor visitor, IFileHandle directory, IProgressMonitor monitor, int deep, ArrayList searchedFiles) {
        if (deep == 0) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (searchedFiles.contains(directory)) {
            return;
        }
        IFileHandle[] childFiles = directory.getChildren();
        if (childFiles == null) {
            return;
        }
        ArrayList subDirs = new ArrayList();
        int i = 0;
        while (i < childFiles.length) {
            if (monitor.isCanceled()) {
                return;
            }
            IFileHandle file = childFiles[i];
            monitor.subTask(NLS.bind((String)"Searching {0}", (Object)file.getCanonicalPath()));
            if ((!file.isDirectory() || file.getCanonicalPath().equals(file.toOSString())) && visitor.visit(file)) {
                while (!subDirs.isEmpty()) {
                    IFileHandle subDir = (IFileHandle)subDirs.remove(0);
                    this.visitFolder(visitor, subDir, monitor, deep - 1, searchedFiles);
                }
            }
            ++i;
        }
        searchedFiles.add(directory);
    }
}

