/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.util;

import java.util.EmptyStackException;
import junit.framework.TestCase;
import org.eclipse.dltk.utils.CharacterStack;

public class CharacterStackTests
extends TestCase {
    private CharacterStack stack;

    protected void setUp() throws Exception {
        this.stack = new CharacterStack();
    }

    public void testPush() {
        this.stack.push('A');
        CharacterStackTests.assertEquals((int)1, (int)this.stack.size());
    }

    public void testPop() {
        this.stack.push('A');
        this.stack.push('B');
        CharacterStackTests.assertEquals((char)'B', (char)this.stack.pop());
        CharacterStackTests.assertEquals((char)'A', (char)this.stack.pop());
    }

    public void testPeek() {
        this.stack.push('A');
        CharacterStackTests.assertEquals((char)'A', (char)this.stack.peek());
        this.stack.push('B');
        CharacterStackTests.assertEquals((char)'B', (char)this.stack.peek());
    }

    public void testEmptyPop() {
        try {
            this.stack.pop();
            CharacterStackTests.fail((String)"should throw EmptyStackException");
        }
        catch (EmptyStackException emptyStackException) {}
    }

    public void testEmptyPeek() {
        try {
            this.stack.peek();
            CharacterStackTests.fail((String)"should throw EmptyStackException");
        }
        catch (EmptyStackException emptyStackException) {}
    }
}

