/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter;

import java.net.URL;
import org.eclipse.dltk.ui.formatter.FormatterMessages;
import org.eclipse.dltk.ui.formatter.FormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.FormatterPreviewUtils;
import org.eclipse.dltk.ui.formatter.IFormatterControlManager;
import org.eclipse.dltk.ui.formatter.IFormatterModifiyTabPage;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.internal.WhitespaceCharacterPainter;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class FormatterModifyTabPage
implements IFormatterModifiyTabPage {
    protected static final String SHOW_INVISIBLE_PREFERENCE_KEY = "invisible.characters";
    private final IFormatterModifyDialog dialog;
    private ISourceViewer previewViewer;
    private Button fShowInvisibleButton;
    private WhitespaceCharacterPainter whitespaceCharacterPainter = null;
    protected PixelConverter fPixelConverter;

    public FormatterModifyTabPage(IFormatterModifyDialog dialog) {
        this.dialog = dialog;
    }

    public Composite createContents(IFormatterControlManager manager, Composite parent) {
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)parent);
        }
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setFont(parent.getFont());
        Composite scrollContainer = new Composite((Composite)sashForm, 0);
        GridData gridData = new GridData(4, 4, true, true);
        scrollContainer.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        scrollContainer.setLayout((Layout)layout);
        ScrolledComposite scroll = new ScrolledComposite(scrollContainer, 768);
        scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        final Composite settingsContainer = new Composite((Composite)scroll, 0);
        settingsContainer.setFont(sashForm.getFont());
        scroll.setContent((Control)settingsContainer);
        settingsContainer.setLayout((Layout)new PageLayout(scroll, 400, 400));
        settingsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite settingsPane = new Composite(settingsContainer, 0);
        settingsPane.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(1, false);
        layout.verticalSpacing = (int)(1.5 * (double)this.fPixelConverter.convertVerticalDLUsToPixels(4));
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        settingsPane.setLayout((Layout)layout);
        this.createOptions(manager, settingsPane);
        settingsContainer.setSize(settingsContainer.computeSize(-1, -1));
        scroll.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                settingsContainer.setSize(settingsContainer.computeSize(-1, -1));
            }
        });
        Label sashHandle = new Label(scrollContainer, 514);
        gridData = new GridData(131072, 4, false, true);
        sashHandle.setLayoutData((Object)gridData);
        Composite previewPane = new Composite((Composite)sashForm, 0);
        previewPane.setLayout((Layout)this.createGridLayout(4, true));
        previewPane.setFont(sashForm.getFont());
        this.doCreatePreviewPane(previewPane, 4);
        sashForm.setWeights(new int[]{3, 3});
        return sashForm;
    }

    protected void updateShowInvisible(boolean value) {
        if (value) {
            if (this.whitespaceCharacterPainter == null) {
                this.whitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)this.previewViewer);
                ((ITextViewerExtension2)this.previewViewer).addPainter((IPainter)this.whitespaceCharacterPainter);
            }
        } else if (this.whitespaceCharacterPainter != null) {
            ((ITextViewerExtension2)this.previewViewer).removePainter((IPainter)this.whitespaceCharacterPainter);
            this.whitespaceCharacterPainter = null;
        }
    }

    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        FormatterModifyTabPage.createLabel(numColumns - 1, composite, FormatterMessages.FormatterModifyTabPage_preview_label_text);
        this.fShowInvisibleButton = new Button(composite, 32);
        this.fShowInvisibleButton.setText(FormatterMessages.FormatterModifyTabPage_showInvisible);
        this.fShowInvisibleButton.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.fShowInvisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newValue = FormatterModifyTabPage.this.fShowInvisibleButton.getSelection();
                FormatterModifyTabPage.this.updateShowInvisible(newValue);
                FormatterModifyTabPage.this.getDialogSettings().put(FormatterModifyTabPage.SHOW_INVISIBLE_PREFERENCE_KEY, newValue);
            }
        });
        this.previewViewer = this.dialog.getOwner().createPreview(composite);
        boolean savedValue = this.getDialogSettings().getBoolean(SHOW_INVISIBLE_PREFERENCE_KEY);
        this.fShowInvisibleButton.setSelection(savedValue);
        this.updateShowInvisible(savedValue);
        GridData gd = FormatterModifyTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        if (this.previewViewer instanceof TextViewer) {
            ((TextViewer)this.previewViewer).getControl().setLayoutData((Object)gd);
        }
        return composite;
    }

    private IDialogSettings getDialogSettings() {
        return ((FormatterModifyDialog)this.dialog).fDialogSettings;
    }

    public void updatePreview() {
        if (this.previewViewer != null) {
            FormatterPreviewUtils.updatePreview(this.previewViewer, this.getPreviewContent(), this.dialog.getFormatterFactory(), this.dialog.getPreferences());
        }
    }

    protected abstract void createOptions(IFormatterControlManager var1, Composite var2);

    protected URL getPreviewContent() {
        return null;
    }

    protected static Label createLabel(int numColumns, Composite parent, String text) {
        return FormatterModifyTabPage.createLabel(numColumns, parent, text, 768);
    }

    protected static Label createLabel(int numColumns, Composite parent, String text, int gridDataStyle) {
        Label label = new Label(parent, 64);
        label.setFont(parent.getFont());
        label.setText(text);
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        label.setLayoutData((Object)FormatterModifyTabPage.createGridData(numColumns, gridDataStyle, pixelConverter.convertHorizontalDLUsToPixels(150)));
        return label;
    }

    protected GridLayout createGridLayout(int numColumns, boolean margins) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        if (margins) {
            layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        return layout;
    }

    protected static GridData createGridData(int numColumns, int style, int widthHint) {
        GridData gd = new GridData(style);
        gd.horizontalSpan = numColumns;
        gd.widthHint = widthHint;
        return gd;
    }

    private static class PageLayout
    extends Layout {
        private final ScrolledComposite fContainer;
        private final int fMinimalWidth;
        private final int fMinimalHight;

        private PageLayout(ScrolledComposite container, int minimalWidth, int minimalHight) {
            this.fContainer = container;
            this.fMinimalWidth = minimalWidth;
            this.fMinimalHight = minimalHight;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = this.fMinimalWidth;
            int y = this.fMinimalHight;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            Rectangle area = this.fContainer.getClientArea();
            if (area.width > x) {
                this.fContainer.setExpandHorizontal(true);
            } else {
                this.fContainer.setExpandHorizontal(false);
            }
            if (area.height > y) {
                this.fContainer.setExpandVertical(true);
            } else {
                this.fContainer.setExpandVertical(false);
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }
    }
}

