/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.reference.resolvers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.search.FieldReferenceMatch;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IReferenceResolver;
import org.eclipse.dltk.internal.javascript.reference.resolvers.IResolvableReference;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.AbstractCallResultReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.VaribleDeclarationReference;
import org.eclipse.dltk.javascript.core.FunctionDeclarationReference;
import org.eclipse.dltk.javascript.core.JavaScriptLanguageToolkit;
import org.eclipse.dltk.javascript.internal.core.mixin.JavaScriptMixinModel;

public class SourceBasedResolver
implements IReferenceResolver,
IExecutableExtension {
    private ISourceModule module;
    protected static IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.javascript.core.nature");
    protected static IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
    protected static int EXACT_RULE = 8;

    public boolean canResolve(ISourceModule module) {
        return true;
    }

    public Set getChilds(IResolvableReference ref) {
        if (ref instanceof AbstractCallResultReference) {
            SimpleReference fr;
            AbstractCallResultReference cm = (AbstractCallResultReference)ref;
            String id = cm.getId();
            List result = this.searchMethods(id);
            HashSet hashSet = new HashSet();
            int a = 0;
            while (a < result.size()) {
                fr = (FunctionDeclarationReference)((Object)result.get(a));
                HostCollection ms = fr.getCollection();
                IReference reference = ms.getReference(cm.getResultId());
                if (reference != null) {
                    hashSet.addAll(reference.getChilds(true));
                }
                ++a;
            }
            result = this.searchRefs(id);
            a = 0;
            while (a < result.size()) {
                fr = (VaribleDeclarationReference)((Object)result.get(a));
                IReference reference = fr.getReference().getChild(cm.getResultId(), true);
                if (reference != null) {
                    hashSet.addAll(reference.getChilds(true));
                }
                ++a;
            }
            if (hashSet.isEmpty()) {
                return null;
            }
            return hashSet;
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    protected List searchMethods(String name) {
        final ArrayList result = new ArrayList(2);
        try {
            this.searchMethodDeclarations(name, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    FieldReferenceMatch fr = (FieldReferenceMatch)match;
                    ASTNode node = fr.getNode();
                    if (node instanceof FunctionDeclarationReference) {
                        FunctionDeclarationReference funcRef = (FunctionDeclarationReference)node;
                        result.add(funcRef);
                    }
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected List searchRefs(String name) {
        final ArrayList result = new ArrayList(2);
        try {
            this.searchMethodDefs(name, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    FieldReferenceMatch fr = (FieldReferenceMatch)match;
                    ASTNode node = fr.getNode();
                    if (node instanceof VaribleDeclarationReference) {
                        VaribleDeclarationReference funcRef = (VaribleDeclarationReference)node;
                        result.add(funcRef);
                    }
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void searchMethodDeclarations(String methodName, SearchRequestor resultCollector) throws CoreException {
        this.search("!!!" + methodName, 2, 1, resultCollector);
    }

    protected void searchMethodDefs(String methodName, SearchRequestor resultCollector) throws CoreException {
        this.search(methodName, 2, 1, resultCollector);
    }

    private void search(String patternString, int searchFor, int limitTo, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, resultCollector);
    }

    private void search(String patternString, int searchFor, int limitTo, int matchRule, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)JavaScriptLanguageToolkit.getDefault());
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    public Set resolveGlobals(String id) {
        JavaScriptMixinModel m = JavaScriptMixinModel.getInstance();
        String key = String.valueOf('{') + id.replace('.', '{');
        String[] findElements = m.findElements(key);
        HashSet<Object> result = new HashSet<Object>();
        int a = 0;
        while (a < findElements.length) {
            String keye;
            IMixinElement mixinElement = JavaScriptMixinModel.getRawInstance().get(findElements[a]);
            if (mixinElement != null && (keye = mixinElement.getKey().substring(key.length())).indexOf(123) == -1 && mixinElement != null) {
                Object[] allObjects = mixinElement.getObjects(this.module);
                int i = 0;
                while (i < allObjects.length) {
                    result.add(allObjects[i]);
                    ++i;
                }
            }
            ++a;
        }
        return result;
    }

    public void processCall(String call, String objId) {
    }

    public void init() {
    }

    public void init(ReferenceResolverContext owner) {
        this.module = owner.module;
    }
}

