/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.javascript.core.JavaScriptKeywords;
import org.eclipse.dltk.javascript.internal.ui.rules.FloatNumberRule;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWhitespaceDetector;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWordDetector;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptWordRule;
import org.eclipse.dltk.javascript.ui.scriptcolor.provider.IScriptColorProvider;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class JavascriptCodeScanner
extends AbstractScriptScanner {
    private static String fgReturnKeyword = "return";
    private static String[] fgTokenProperties = new String[]{"DLTK_single_line_comment", "DLTK_default", "DLTK_keyword", "DLTK_keyword_return", "DLTK_number", "DLTK_function_definition"};
    private static IScriptColorProvider[] providers;

    static {
        JavascriptCodeScanner.initProviders();
    }

    public static IScriptColorProvider[] getScriptColorProviders() {
        return providers;
    }

    private static void initProviders() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.dltk.javascript.ui.keywordsprovider");
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Object> providerList = new ArrayList<Object>();
        int a = 0;
        while (a < extensions.length) {
            IConfigurationElement[] configurationElements = extensions[a].getConfigurationElements();
            int b = 0;
            while (b < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[b];
                try {
                    Object createExecutableExtension = configurationElement.createExecutableExtension("class");
                    if (createExecutableExtension instanceof IScriptColorProvider) {
                        providerList.add(createExecutableExtension);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++b;
            }
            ++a;
        }
        IScriptColorProvider[] pr = new IScriptColorProvider[providerList.size()];
        providerList.toArray(pr);
        providers = pr;
    }

    public JavascriptCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        int j;
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = this.getToken("DLTK_keyword");
        Token keywordReturn = this.getToken("DLTK_keyword_return");
        Token other = this.getToken("DLTK_default");
        Token def = this.getToken("DLTK_function_definition");
        Token number = this.getToken("DLTK_number");
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavascriptWhitespaceDetector()));
        JavascriptWordRule wordRule = new JavascriptWordRule(new JavascriptWordDetector(), (IToken)other, null, (IToken)def);
        int i = 0;
        while (i < JavaScriptKeywords.getJavaScriptKeywords().length) {
            wordRule.addWord(JavaScriptKeywords.getJavaScriptKeywords()[i], (IToken)keyword);
            ++i;
        }
        wordRule.addWord(fgReturnKeyword, (IToken)keywordReturn);
        i = 0;
        while (i < providers.length) {
            String[] keywords = providers[i].getKeywords();
            if (keywords != null) {
                j = 0;
                while (j < keywords.length) {
                    wordRule.addWord(keywords[j], providers[i].getToken(keywords[j]));
                    ++j;
                }
            }
            ++i;
        }
        rules.add(wordRule);
        rules.add(new FloatNumberRule((IToken)number));
        i = 0;
        while (i < providers.length) {
            IRule[] r = providers[i].getRules();
            if (r != null) {
                j = 0;
                while (j < r.length) {
                    rules.add(r[j]);
                    ++j;
                }
            }
            ++i;
        }
        this.setDefaultReturnToken((IToken)other);
        return rules;
    }
}

